/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.compute.task;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.ignite3.compute.JobState;
import org.apache.ignite3.compute.TaskState;
import org.apache.ignite3.compute.task.TaskExecution;
import org.apache.ignite3.internal.thread.PublicApiThreading;
import org.jetbrains.annotations.Nullable;

public class AntiHijackTaskExecution<R>
implements TaskExecution<R> {
    private final TaskExecution<R> execution;
    private final Executor asyncContinuationExecutor;

    public AntiHijackTaskExecution(TaskExecution<R> execution, Executor asyncContinuationExecutor) {
        this.execution = execution;
        this.asyncContinuationExecutor = asyncContinuationExecutor;
    }

    @Override
    public CompletableFuture<List<@Nullable JobState>> statesAsync() {
        return this.preventThreadHijack(this.execution.statesAsync());
    }

    @Override
    public CompletableFuture<R> resultAsync() {
        return this.preventThreadHijack(this.execution.resultAsync());
    }

    @Override
    public CompletableFuture<@Nullable TaskState> stateAsync() {
        return this.preventThreadHijack(this.execution.stateAsync());
    }

    @Override
    public CompletableFuture<@Nullable Boolean> changePriorityAsync(int newPriority) {
        return this.preventThreadHijack(this.execution.changePriorityAsync(newPriority));
    }

    private <T> CompletableFuture<T> preventThreadHijack(CompletableFuture<T> originalFuture) {
        return PublicApiThreading.preventThreadHijack(originalFuture, this.asyncContinuationExecutor);
    }
}

