/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.compute.message;

import java.util.UUID;
import org.apache.ignite3.internal.compute.ComputeMessagesFactory;
import org.apache.ignite3.internal.compute.ComputeMessagesTypeInfos;
import org.apache.ignite3.internal.compute.message.JobStateRequest;
import org.apache.ignite3.internal.compute.message.JobStateRequestBuilder;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;

class JobStateRequestDeserializer
implements MessageDeserializer<JobStateRequest> {
    private final JobStateRequestBuilder msg;

    JobStateRequestDeserializer(ComputeMessagesFactory messageFactory) {
        this.msg = messageFactory.jobStateRequest();
    }

    @Override
    public Class<JobStateRequest> klass() {
        return JobStateRequest.class;
    }

    @Override
    public JobStateRequest getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(ComputeMessagesTypeInfos.jobStateRequest());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                UUID tmp = reader.readUuid("jobId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.jobId(tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(JobStateRequest.class);
    }
}

