/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.compute.message;

import java.util.Objects;
import java.util.UUID;
import org.apache.ignite3.internal.compute.message.JobOwnerRequest;
import org.apache.ignite3.internal.compute.message.JobOwnerRequestBuilder;
import org.apache.ignite3.internal.compute.message.JobOwnerRequestSerializer;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;

public class JobOwnerRequestImpl
implements JobOwnerRequest,
Cloneable {
    public static final short GROUP_TYPE = 6;
    public static final short TYPE = 13;
    @IgniteToStringInclude
    private final UUID jobId;

    private JobOwnerRequestImpl(UUID jobId) {
        this.jobId = jobId;
    }

    @Override
    public UUID jobId() {
        return this.jobId;
    }

    public MessageSerializer serializer() {
        return JobOwnerRequestSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 6;
    }

    public String toString() {
        return S.toString(JobOwnerRequestImpl.class, this);
    }

    @Override
    public short messageType() {
        return 13;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        JobOwnerRequestImpl otherMessage = (JobOwnerRequestImpl)other;
        return Objects.equals(this.jobId, otherMessage.jobId);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.jobId);
        return result;
    }

    @Override
    public JobOwnerRequestImpl clone() {
        try {
            return (JobOwnerRequestImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static JobOwnerRequestBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements JobOwnerRequestBuilder {
        private UUID jobId;

        private Builder() {
        }

        @Override
        public JobOwnerRequestBuilder jobId(UUID jobId) {
            Objects.requireNonNull(jobId, "jobId is not marked @Nullable");
            this.jobId = jobId;
            return this;
        }

        @Override
        public UUID jobId() {
            return this.jobId;
        }

        @Override
        public JobOwnerRequest build() {
            return new JobOwnerRequestImpl(Objects.requireNonNull(this.jobId, "jobId is not marked @Nullable"));
        }

        @Override
        public JobOwnerRequest buildDeserialized() {
            return new JobOwnerRequestImpl(this.jobId);
        }
    }
}

