/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.compute.message;

import java.util.Objects;
import org.apache.ignite3.internal.compute.message.DeploymentUnitMsg;
import org.apache.ignite3.internal.compute.message.DeploymentUnitMsgBuilder;
import org.apache.ignite3.internal.compute.message.DeploymentUnitMsgSerializer;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;

public class DeploymentUnitMsgImpl
implements DeploymentUnitMsg,
Cloneable {
    public static final short GROUP_TYPE = 6;
    public static final short TYPE = 2;
    @IgniteToStringInclude
    private final String name;
    @IgniteToStringInclude
    private final String version;

    private DeploymentUnitMsgImpl(String name, String version) {
        this.name = name;
        this.version = version;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String version() {
        return this.version;
    }

    public MessageSerializer serializer() {
        return DeploymentUnitMsgSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 6;
    }

    public String toString() {
        return S.toString(DeploymentUnitMsgImpl.class, this);
    }

    @Override
    public short messageType() {
        return 2;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DeploymentUnitMsgImpl otherMessage = (DeploymentUnitMsgImpl)other;
        return Objects.equals(this.name, otherMessage.name) && Objects.equals(this.version, otherMessage.version);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.name, this.version);
        return result;
    }

    @Override
    public DeploymentUnitMsgImpl clone() {
        try {
            return (DeploymentUnitMsgImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static DeploymentUnitMsgBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements DeploymentUnitMsgBuilder {
        private String name;
        private String version;

        private Builder() {
        }

        @Override
        public DeploymentUnitMsgBuilder name(String name) {
            Objects.requireNonNull(name, "name is not marked @Nullable");
            this.name = name;
            return this;
        }

        @Override
        public DeploymentUnitMsgBuilder version(String version) {
            Objects.requireNonNull(version, "version is not marked @Nullable");
            this.version = version;
            return this;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String version() {
            return this.version;
        }

        @Override
        public DeploymentUnitMsg build() {
            return new DeploymentUnitMsgImpl(Objects.requireNonNull(this.name, "name is not marked @Nullable"), Objects.requireNonNull(this.version, "version is not marked @Nullable"));
        }

        @Override
        public DeploymentUnitMsg buildDeserialized() {
            return new DeploymentUnitMsgImpl(this.name, this.version);
        }
    }
}

