/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.compute.executor;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.function.Function;
import org.apache.ignite3.internal.compute.executor.AbstractSecuredTableView;
import org.apache.ignite3.internal.table.criteria.CursorAdapter;
import org.apache.ignite3.lang.AsyncCursor;
import org.apache.ignite3.lang.Cursor;
import org.apache.ignite3.lang.NullableValue;
import org.apache.ignite3.table.ContinuousQueryOptions;
import org.apache.ignite3.table.DataStreamerItem;
import org.apache.ignite3.table.DataStreamerOptions;
import org.apache.ignite3.table.DataStreamerReceiverDescriptor;
import org.apache.ignite3.table.KeyValueView;
import org.apache.ignite3.table.QualifiedName;
import org.apache.ignite3.table.TableRowEventBatch;
import org.apache.ignite3.table.criteria.Criteria;
import org.apache.ignite3.table.criteria.CriteriaQueryOptions;
import org.apache.ignite3.tx.Transaction;
import org.gridgain.internal.rbac.authorization.Authorizer;
import org.gridgain.internal.rbac.privileges.Privilege;
import org.gridgain.internal.security.context.SecurityContext;
import org.jetbrains.annotations.Nullable;

class SecuredKeyValueView<K, V>
extends AbstractSecuredTableView
implements KeyValueView<K, V> {
    private final KeyValueView<K, V> delegate;

    SecuredKeyValueView(KeyValueView<K, V> delegate, Authorizer authorizer, SecurityContext context, QualifiedName name) {
        super(authorizer, context, name);
        this.delegate = delegate;
    }

    @Override
    @Nullable
    public V get(@Nullable Transaction tx, K key) {
        return this.sync(this.getAsync(tx, key));
    }

    @Override
    public CompletableFuture<V> getAsync(@Nullable Transaction tx, K key) {
        return this.authorizer.authorizeThenCompose(this.context, this.selectPrivilege(), () -> this.delegate.getAsync(tx, key));
    }

    @Override
    public NullableValue<V> getNullable(@Nullable Transaction tx, K key) {
        return this.sync(this.getNullableAsync(tx, key));
    }

    @Override
    public CompletableFuture<NullableValue<V>> getNullableAsync(@Nullable Transaction tx, K key) {
        return this.authorizer.authorizeThenCompose(this.context, this.selectPrivilege(), () -> this.delegate.getNullableAsync(tx, key));
    }

    @Override
    @Nullable
    public V getOrDefault(@Nullable Transaction tx, K key, @Nullable V defaultValue) {
        return this.sync(this.getOrDefaultAsync(tx, key, defaultValue));
    }

    @Override
    public CompletableFuture<V> getOrDefaultAsync(@Nullable Transaction tx, K key, @Nullable V defaultValue) {
        return this.authorizer.authorizeThenCompose(this.context, this.selectPrivilege(), () -> this.delegate.getOrDefaultAsync(tx, key, defaultValue));
    }

    @Override
    public Map<K, V> getAll(@Nullable Transaction tx, Collection<K> keys) {
        return this.sync(this.getAllAsync(tx, keys));
    }

    @Override
    public CompletableFuture<Map<K, V>> getAllAsync(@Nullable Transaction tx, Collection<K> keys) {
        return this.authorizer.authorizeThenCompose(this.context, this.selectPrivilege(), () -> this.delegate.getAllAsync(tx, keys));
    }

    @Override
    public boolean contains(@Nullable Transaction tx, K key) {
        return this.sync(this.containsAsync(tx, key));
    }

    @Override
    public CompletableFuture<Boolean> containsAsync(@Nullable Transaction tx, K key) {
        return this.authorizer.authorizeThenCompose(this.context, this.selectPrivilege(), () -> this.delegate.containsAsync(tx, key));
    }

    @Override
    public boolean containsAll(@Nullable Transaction tx, Collection<K> keys) {
        return this.sync(this.containsAllAsync(tx, keys));
    }

    @Override
    public CompletableFuture<Boolean> containsAllAsync(@Nullable Transaction tx, Collection<K> keys) {
        return this.authorizer.authorizeThenCompose(this.context, this.selectPrivilege(), () -> this.delegate.containsAllAsync(tx, keys));
    }

    @Override
    public void put(@Nullable Transaction tx, K key, @Nullable V val) {
        this.sync(this.putAsync(tx, key, val));
    }

    @Override
    public CompletableFuture<Void> putAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        return this.authorizer.authorizeThenCompose(this.context, this.upsertPrivilege(), () -> this.delegate.putAsync(tx, key, val));
    }

    @Override
    public void putAll(@Nullable Transaction tx, Map<K, V> pairs) {
        this.sync(this.putAllAsync(tx, pairs));
    }

    @Override
    public CompletableFuture<Void> putAllAsync(@Nullable Transaction tx, Map<K, V> pairs) {
        return this.authorizer.authorizeThenCompose(this.context, this.upsertPrivilege(), () -> this.delegate.putAllAsync(tx, pairs));
    }

    @Override
    @Nullable
    public V getAndPut(@Nullable Transaction tx, K key, @Nullable V val) {
        return this.sync(this.getAndPutAsync(tx, key, val));
    }

    @Override
    public CompletableFuture<V> getAndPutAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        return this.authorizer.authorizeThenCompose(this.context, this.upsertPrivilege(), () -> this.delegate.getAndPutAsync(tx, key, val));
    }

    @Override
    public NullableValue<V> getNullableAndPut(@Nullable Transaction tx, K key, @Nullable V val) {
        return this.sync(this.getNullableAndPutAsync(tx, key, val));
    }

    @Override
    public CompletableFuture<NullableValue<V>> getNullableAndPutAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        return this.authorizer.authorizeThenCompose(this.context, this.upsertPrivilege(), () -> this.delegate.getNullableAndPutAsync(tx, key, val));
    }

    @Override
    public boolean putIfAbsent(@Nullable Transaction tx, K key, @Nullable V val) {
        return this.sync(this.putIfAbsentAsync(tx, key, val));
    }

    @Override
    public CompletableFuture<Boolean> putIfAbsentAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        return this.authorizer.authorizeThenCompose(this.context, this.insertPrivilege(), () -> this.delegate.putIfAbsentAsync(tx, key, val));
    }

    @Override
    public boolean remove(@Nullable Transaction tx, K key) {
        return this.sync(this.removeAsync(tx, key));
    }

    @Override
    public boolean remove(@Nullable Transaction tx, K key, V val) {
        return this.sync(this.removeAsync(tx, key, val));
    }

    @Override
    public CompletableFuture<Boolean> removeAsync(@Nullable Transaction tx, K key) {
        return this.authorizer.authorizeThenCompose(this.context, this.deletePrivilege(), () -> this.delegate.removeAsync(tx, key));
    }

    @Override
    public CompletableFuture<Boolean> removeAsync(@Nullable Transaction tx, K key, V val) {
        return this.authorizer.authorizeThenCompose(this.context, this.deletePrivilege(), () -> this.delegate.removeAsync(tx, key, val));
    }

    @Override
    public Collection<K> removeAll(@Nullable Transaction tx, Collection<K> keys) {
        return this.sync(this.removeAllAsync(tx, keys));
    }

    @Override
    public void removeAll(@Nullable Transaction tx) {
        this.sync(this.removeAllAsync(tx));
    }

    @Override
    public CompletableFuture<Collection<K>> removeAllAsync(@Nullable Transaction tx, Collection<K> keys) {
        return this.authorizer.authorizeThenCompose(this.context, this.deletePrivilege(), () -> this.delegate.removeAllAsync(tx, keys));
    }

    @Override
    public CompletableFuture<Void> removeAllAsync(@Nullable Transaction tx) {
        return this.authorizer.authorizeThenCompose(this.context, this.deletePrivilege(), () -> this.delegate.removeAllAsync(tx));
    }

    @Override
    @Nullable
    public V getAndRemove(@Nullable Transaction tx, K key) {
        return this.sync(this.getAndRemoveAsync(tx, key));
    }

    @Override
    public CompletableFuture<V> getAndRemoveAsync(@Nullable Transaction tx, K key) {
        Set<Privilege> privileges = Set.of(this.selectPrivilege(), this.deletePrivilege());
        return this.authorizer.authorizeThenCompose(this.context, privileges, () -> this.delegate.getAndRemoveAsync(tx, key));
    }

    @Override
    public NullableValue<V> getNullableAndRemove(@Nullable Transaction tx, K key) {
        return this.sync(this.getNullableAndRemoveAsync(tx, key));
    }

    @Override
    public CompletableFuture<NullableValue<V>> getNullableAndRemoveAsync(@Nullable Transaction tx, K key) {
        Set<Privilege> privileges = Set.of(this.selectPrivilege(), this.deletePrivilege());
        return this.authorizer.authorizeThenCompose(this.context, privileges, () -> this.delegate.getNullableAndRemoveAsync(tx, key));
    }

    @Override
    public boolean replace(@Nullable Transaction tx, K key, @Nullable V val) {
        return this.sync(this.replaceAsync(tx, key, val));
    }

    @Override
    public boolean replace(@Nullable Transaction tx, K key, V oldValue, @Nullable V newValue) {
        return this.sync(this.replaceAsync(tx, key, oldValue, newValue));
    }

    @Override
    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        return this.authorizer.authorizeThenCompose(this.context, this.replacePrivilege(), () -> this.delegate.replaceAsync(tx, key, val));
    }

    @Override
    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, K key, @Nullable V oldVal, @Nullable V newVal) {
        return this.authorizer.authorizeThenCompose(this.context, this.replacePrivilege(), () -> this.delegate.replaceAsync(tx, key, oldVal, newVal));
    }

    @Override
    @Nullable
    public V getAndReplace(@Nullable Transaction tx, @Nullable K key, @Nullable V val) {
        return this.sync(this.getAndReplaceAsync(tx, key, val));
    }

    @Override
    public CompletableFuture<V> getAndReplaceAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        return this.authorizer.authorizeThenCompose(this.context, this.replacePrivilege(), () -> this.delegate.getAndReplaceAsync(tx, key, val));
    }

    @Override
    public NullableValue<V> getNullableAndReplace(@Nullable Transaction tx, K key, @Nullable V val) {
        return this.sync(this.getNullableAndReplaceAsync(tx, key, val));
    }

    @Override
    public CompletableFuture<NullableValue<V>> getNullableAndReplaceAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        return this.authorizer.authorizeThenCompose(this.context, this.replacePrivilege(), () -> this.delegate.getNullableAndReplaceAsync(tx, key, val));
    }

    @Override
    public CompletableFuture<Void> streamData(Flow.Publisher<DataStreamerItem<Map.Entry<K, V>>> publisher, @Nullable DataStreamerOptions options) {
        return this.authorizer.authorizeThenCompose(this.context, this.upsertPrivilege(), () -> this.delegate.streamData(publisher, options));
    }

    @Override
    public <E, V2, A, R> CompletableFuture<Void> streamData(Flow.Publisher<E> publisher, DataStreamerReceiverDescriptor<V2, A, R> receiver, Function<E, Map.Entry<K, V>> keyFunc, Function<E, V2> payloadFunc, @Nullable A receiverArg, @Nullable Flow.Subscriber<R> resultSubscriber, @Nullable DataStreamerOptions options) {
        return this.authorizer.authorizeThenCompose(this.context, this.upsertPrivilege(), () -> this.delegate.streamData(publisher, receiver, keyFunc, payloadFunc, receiverArg, resultSubscriber, options));
    }

    @Override
    public void queryContinuously(Flow.Subscriber<TableRowEventBatch<Map.Entry<K, V>>> subscriber, @Nullable ContinuousQueryOptions options) {
        this.authorizer.authorizeAsync(this.context, this.selectPrivilege()).whenComplete((unused, throwable) -> {
            if (throwable != null) {
                subscriber.onError((Throwable)throwable);
            } else {
                this.delegate.queryContinuously(subscriber, options);
            }
        });
    }

    @Override
    public Cursor<Map.Entry<K, V>> query(@Nullable Transaction tx, @Nullable Criteria criteria, @Nullable String indexName, @Nullable CriteriaQueryOptions opts) {
        return new CursorAdapter<Map.Entry<K, V>>(this.sync(this.queryAsync(tx, criteria, indexName, opts)));
    }

    @Override
    public CompletableFuture<AsyncCursor<Map.Entry<K, V>>> queryAsync(@Nullable Transaction tx, @Nullable Criteria criteria, @Nullable String indexName, @Nullable CriteriaQueryOptions opts) {
        return this.authorizer.authorizeThenCompose(this.context, this.selectPrivilege(), () -> this.delegate.queryAsync(tx, criteria, indexName, opts));
    }

    @Override
    public void close() throws Exception {
        this.delegate.close();
    }
}

