/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.compute;

import org.apache.ignite3.internal.compute.PrimaryReplicaNextWorkerSelector;
import org.apache.ignite3.internal.hlc.HybridClock;
import org.apache.ignite3.internal.network.TopologyService;
import org.apache.ignite3.internal.placementdriver.PlacementDriver;
import org.apache.ignite3.internal.replicator.ZonePartitionId;
import org.apache.ignite3.internal.table.TableViewInternal;
import org.apache.ignite3.table.Tuple;
import org.apache.ignite3.table.mapper.Mapper;
import org.jetbrains.annotations.Nullable;

class NextColocatedWorkerSelector<K>
extends PrimaryReplicaNextWorkerSelector {
    @Nullable
    private final K key;
    @Nullable
    private final Mapper<K> keyMapper;
    @Nullable
    private final Tuple tuple;
    private final TableViewInternal table;

    NextColocatedWorkerSelector(PlacementDriver placementDriver, TopologyService topologyService, HybridClock clock, TableViewInternal table, K key, Mapper<K> keyMapper) {
        this(placementDriver, topologyService, clock, table, key, keyMapper, null);
    }

    NextColocatedWorkerSelector(PlacementDriver placementDriver, TopologyService topologyService, HybridClock clock, TableViewInternal table, Tuple tuple) {
        this(placementDriver, topologyService, clock, table, null, null, tuple);
    }

    private NextColocatedWorkerSelector(PlacementDriver placementDriver, TopologyService topologyService, HybridClock clock, TableViewInternal table, @Nullable K key, @Nullable Mapper<K> keyMapper, @Nullable Tuple tuple) {
        super(placementDriver, topologyService, clock);
        this.table = table;
        this.key = key;
        this.keyMapper = keyMapper;
        this.tuple = tuple;
    }

    @Override
    protected ZonePartitionId partitionGroupId() {
        if (this.key != null && this.keyMapper != null) {
            return new ZonePartitionId(this.table.zoneId(), this.table.partitionId(this.key, this.keyMapper));
        }
        return new ZonePartitionId(this.table.zoneId(), this.table.partitionId(this.tuple));
    }
}

