/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cluster.management.raft.commands;

import org.apache.ignite3.internal.cluster.management.network.messages.CmgMessagesTypeInfos;
import org.apache.ignite3.internal.cluster.management.raft.commands.JoinRequestCommand;
import org.apache.ignite3.internal.cluster.management.raft.commands.JoinRequestCommandImpl;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.MessageWriter;

class JoinRequestCommandSerializer
implements MessageSerializer<JoinRequestCommand> {
    public static final JoinRequestCommandSerializer INSTANCE = new JoinRequestCommandSerializer();

    private JoinRequestCommandSerializer() {
    }

    @Override
    public boolean writeMessage(JoinRequestCommand msg, MessageWriter writer) throws MessageMappingException {
        JoinRequestCommandImpl message = (JoinRequestCommandImpl)msg;
        writer.setMessageTypeInfo(CmgMessagesTypeInfos.joinRequestCommand());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)3)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeMessage("clusterTag", message.clusterTag());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeMessage("node", message.node());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeString("version", message.version());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

