/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cluster.management.raft.commands;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite3.internal.cluster.management.raft.commands.ClusterNodeMessage;
import org.apache.ignite3.internal.cluster.management.raft.commands.ClusterNodeMessageBuilder;
import org.apache.ignite3.internal.cluster.management.raft.commands.ClusterNodeMessageSerializer;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;

public class ClusterNodeMessageImpl
implements ClusterNodeMessage,
Cloneable {
    public static final short GROUP_TYPE = 7;
    public static final short TYPE = 60;
    @IgniteToStringInclude
    private final String host;
    @IgniteToStringInclude
    private final UUID id;
    @IgniteToStringInclude
    private final String name;
    @IgniteToStringInclude
    private final int port;
    @IgniteToStringInclude
    private final List<String> storageProfiles;
    @IgniteToStringInclude
    private final Map<String, String> systemAttributes;
    @IgniteToStringInclude
    private final Map<String, String> userAttributes;

    private ClusterNodeMessageImpl(String host, UUID id, String name, int port, List<String> storageProfiles, Map<String, String> systemAttributes, Map<String, String> userAttributes) {
        this.host = host;
        this.id = id;
        this.name = name;
        this.port = port;
        this.storageProfiles = storageProfiles;
        this.systemAttributes = systemAttributes;
        this.userAttributes = userAttributes;
    }

    @Override
    public String host() {
        return this.host;
    }

    @Override
    public UUID id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int port() {
        return this.port;
    }

    @Override
    public List<String> storageProfiles() {
        return this.storageProfiles;
    }

    @Override
    public Map<String, String> systemAttributes() {
        return this.systemAttributes;
    }

    @Override
    public Map<String, String> userAttributes() {
        return this.userAttributes;
    }

    public MessageSerializer serializer() {
        return ClusterNodeMessageSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 7;
    }

    public String toString() {
        return S.toString(ClusterNodeMessageImpl.class, this);
    }

    @Override
    public short messageType() {
        return 60;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ClusterNodeMessageImpl otherMessage = (ClusterNodeMessageImpl)other;
        return Objects.equals(this.host, otherMessage.host) && Objects.equals(this.id, otherMessage.id) && Objects.equals(this.name, otherMessage.name) && Objects.equals(this.storageProfiles, otherMessage.storageProfiles) && Objects.equals(this.systemAttributes, otherMessage.systemAttributes) && Objects.equals(this.userAttributes, otherMessage.userAttributes) && this.port == otherMessage.port;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.port, this.host, this.id, this.name, this.storageProfiles, this.systemAttributes, this.userAttributes);
        return result;
    }

    @Override
    public ClusterNodeMessageImpl clone() {
        try {
            return (ClusterNodeMessageImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static ClusterNodeMessageBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements ClusterNodeMessageBuilder {
        private String host;
        private UUID id;
        private String name;
        private int port;
        private List<String> storageProfiles;
        private Map<String, String> systemAttributes;
        private Map<String, String> userAttributes;

        private Builder() {
        }

        @Override
        public ClusterNodeMessageBuilder host(String host) {
            Objects.requireNonNull(host, "host is not marked @Nullable");
            this.host = host;
            return this;
        }

        @Override
        public ClusterNodeMessageBuilder id(UUID id) {
            Objects.requireNonNull(id, "id is not marked @Nullable");
            this.id = id;
            return this;
        }

        @Override
        public ClusterNodeMessageBuilder name(String name) {
            Objects.requireNonNull(name, "name is not marked @Nullable");
            this.name = name;
            return this;
        }

        @Override
        public ClusterNodeMessageBuilder port(int port) {
            this.port = port;
            return this;
        }

        @Override
        public ClusterNodeMessageBuilder storageProfiles(List<String> storageProfiles) {
            this.storageProfiles = storageProfiles;
            return this;
        }

        @Override
        public ClusterNodeMessageBuilder systemAttributes(Map<String, String> systemAttributes) {
            this.systemAttributes = systemAttributes;
            return this;
        }

        @Override
        public ClusterNodeMessageBuilder userAttributes(Map<String, String> userAttributes) {
            this.userAttributes = userAttributes;
            return this;
        }

        @Override
        public String host() {
            return this.host;
        }

        @Override
        public UUID id() {
            return this.id;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public int port() {
            return this.port;
        }

        @Override
        public List<String> storageProfiles() {
            return this.storageProfiles;
        }

        @Override
        public Map<String, String> systemAttributes() {
            return this.systemAttributes;
        }

        @Override
        public Map<String, String> userAttributes() {
            return this.userAttributes;
        }

        @Override
        public ClusterNodeMessage build() {
            return new ClusterNodeMessageImpl(Objects.requireNonNull(this.host, "host is not marked @Nullable"), Objects.requireNonNull(this.id, "id is not marked @Nullable"), Objects.requireNonNull(this.name, "name is not marked @Nullable"), this.port, this.storageProfiles, this.systemAttributes, this.userAttributes);
        }

        @Override
        public ClusterNodeMessage buildDeserialized() {
            return new ClusterNodeMessageImpl(this.host, this.id, this.name, this.port, this.storageProfiles, this.systemAttributes, this.userAttributes);
        }
    }
}

