/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cluster.management.raft;

import java.io.Serializable;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.cluster.management.ClusterIdStore;
import org.apache.ignite3.internal.cluster.management.ClusterState;
import org.apache.ignite3.internal.cluster.management.ClusterStateV2;
import org.apache.ignite3.internal.cluster.management.MetaStorageInfo;
import org.apache.ignite3.internal.cluster.management.network.messages.CmgMessagesFactory;
import org.apache.ignite3.internal.cluster.management.raft.ClusterStateStorageManager;
import org.apache.ignite3.internal.cluster.management.raft.ValidationManager;
import org.apache.ignite3.internal.cluster.management.raft.ValidationResult;
import org.apache.ignite3.internal.cluster.management.raft.commands.ChangeMetaStorageInfoCommand;
import org.apache.ignite3.internal.cluster.management.raft.commands.ClusterNodeMessage;
import org.apache.ignite3.internal.cluster.management.raft.commands.InitCmgStateCommand;
import org.apache.ignite3.internal.cluster.management.raft.commands.JoinReadyCommand;
import org.apache.ignite3.internal.cluster.management.raft.commands.JoinRequestCommand;
import org.apache.ignite3.internal.cluster.management.raft.commands.NodesLeaveCommand;
import org.apache.ignite3.internal.cluster.management.raft.commands.ReadLogicalTopologyCommand;
import org.apache.ignite3.internal.cluster.management.raft.commands.ReadMetaStorageInfoCommand;
import org.apache.ignite3.internal.cluster.management.raft.commands.ReadStateCommand;
import org.apache.ignite3.internal.cluster.management.raft.commands.ReadValidatedNodesCommand;
import org.apache.ignite3.internal.cluster.management.raft.commands.RollingUpgradeCancel;
import org.apache.ignite3.internal.cluster.management.raft.commands.RollingUpgradeCommit;
import org.apache.ignite3.internal.cluster.management.raft.commands.RollingUpgradeStartCommand;
import org.apache.ignite3.internal.cluster.management.raft.responses.LogicalTopologyResponse;
import org.apache.ignite3.internal.cluster.management.raft.responses.ValidationErrorResponse;
import org.apache.ignite3.internal.cluster.management.topology.LogicalTopology;
import org.apache.ignite3.internal.cluster.management.topology.api.LogicalNode;
import org.apache.ignite3.internal.configuration.ConfigurationRegistry;
import org.apache.ignite3.internal.failure.FailureContext;
import org.apache.ignite3.internal.failure.FailureProcessor;
import org.apache.ignite3.internal.lang.IgniteInternalException;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.network.InternalClusterNode;
import org.apache.ignite3.internal.properties.IgniteProductVersion;
import org.apache.ignite3.internal.raft.RaftGroupConfiguration;
import org.apache.ignite3.internal.raft.ReadCommand;
import org.apache.ignite3.internal.raft.WriteCommand;
import org.apache.ignite3.internal.raft.service.CommandClosure;
import org.apache.ignite3.internal.raft.service.RaftGroupListener;
import org.apache.ignite3.internal.util.IgniteSpinBusyLock;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class CmgRaftGroupListener
implements RaftGroupListener {
    private static final IgniteLogger LOG = Loggers.forClass(CmgRaftGroupListener.class);
    private static final IgniteProductVersion VERSION_WITH_UPGRADE_SUPPORTED = IgniteProductVersion.fromString("9.1.5");
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final ClusterStateStorageManager storageManager;
    private final LogicalTopology logicalTopology;
    private final ValidationManager validationManager;
    private final LongConsumer onLogicalTopologyChanged;
    private final ClusterIdStore clusterIdStore;
    private final FailureProcessor failureProcessor;
    private final CmgMessagesFactory cmgMessagesFactory = new CmgMessagesFactory();
    private final Consumer<RaftGroupConfiguration> onConfigurationCommittedListener;
    private final ConfigurationRegistry clusterConfiguration;

    public CmgRaftGroupListener(ClusterStateStorageManager storageManager, LogicalTopology logicalTopology, ValidationManager validationManager, LongConsumer onLogicalTopologyChanged, ClusterIdStore clusterIdStore, FailureProcessor failureProcessor, Consumer<RaftGroupConfiguration> onConfigurationCommittedListener, ConfigurationRegistry clusterConfiguration) {
        this.storageManager = storageManager;
        this.logicalTopology = logicalTopology;
        this.validationManager = validationManager;
        this.onLogicalTopologyChanged = onLogicalTopologyChanged;
        this.clusterIdStore = clusterIdStore;
        this.failureProcessor = failureProcessor;
        this.onConfigurationCommittedListener = onConfigurationCommittedListener;
        this.clusterConfiguration = clusterConfiguration;
    }

    @Override
    public void onConfigurationCommitted(RaftGroupConfiguration config, long lastAppliedIndex, long lastAppliedTerm) {
        this.onConfigurationCommittedListener.accept(config);
    }

    @Override
    public void onRead(Iterator<CommandClosure<ReadCommand>> iterator) {
        if (!this.busyLock.enterBusy()) {
            iterator.forEachRemaining(clo -> clo.result(new RaftGroupListener.ShutdownException()));
        }
        try {
            this.onReadBusy(iterator);
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private void onReadBusy(Iterator<CommandClosure<ReadCommand>> iterator) {
        while (iterator.hasNext()) {
            CommandClosure<ReadCommand> clo = iterator.next();
            ReadCommand command = clo.command();
            if (command instanceof ReadStateCommand) {
                clo.result(this.storageManager.getClusterState());
                continue;
            }
            if (command instanceof ReadLogicalTopologyCommand) {
                clo.result(new LogicalTopologyResponse(this.logicalTopology.getLogicalTopology()));
                continue;
            }
            if (command instanceof ReadValidatedNodesCommand) {
                clo.result(this.getValidatedNodes());
                continue;
            }
            if (!(command instanceof ReadMetaStorageInfoCommand)) continue;
            clo.result(this.getMetaStorageInfo());
        }
    }

    private HashSet<LogicalNode> getValidatedNodes() {
        List<LogicalNode> validatedNodes = this.storageManager.getValidatedNodes();
        Set<LogicalNode> logicalTopologyNodes = this.logicalTopology.getLogicalTopology().nodes();
        HashSet<LogicalNode> result = new HashSet<LogicalNode>(IgniteUtils.capacity(validatedNodes.size() + logicalTopologyNodes.size()));
        result.addAll(validatedNodes);
        result.addAll(logicalTopologyNodes);
        return result;
    }

    @Nullable
    private MetaStorageInfo getMetaStorageInfo() {
        ClusterState clusterState = this.storageManager.getClusterState();
        if (clusterState == null) {
            return null;
        }
        return this.cmgMessagesFactory.metaStorageInfo().metaStorageNodes(clusterState.metaStorageNodes()).metastorageRepairingConfigIndex(this.storageManager.getMetastorageRepairingConfigIndex()).build();
    }

    @Override
    public void onWrite(Iterator<CommandClosure<WriteCommand>> iterator) {
        while (iterator.hasNext()) {
            CommandClosure<WriteCommand> clo = iterator.next();
            try {
                Object response;
                WriteCommand command = clo.command();
                if (command instanceof InitCmgStateCommand) {
                    response = this.initCmgState((InitCmgStateCommand)command);
                    clo.result((Serializable)response);
                    continue;
                }
                if (command instanceof JoinRequestCommand) {
                    response = this.validateNode((JoinRequestCommand)command);
                    clo.result(((ValidationResult)response).isValid() ? null : new ValidationErrorResponse(((ValidationResult)response).errorDescription(), ((ValidationResult)response).isInvalidNodeConfig()));
                    continue;
                }
                if (command instanceof JoinReadyCommand) {
                    response = this.completeValidation((JoinReadyCommand)command);
                    if (((ValidationResult)response).isValid()) {
                        this.onLogicalTopologyChanged.accept(clo.term());
                    }
                    clo.result(((ValidationResult)response).isValid() ? null : new ValidationErrorResponse(((ValidationResult)response).errorDescription(), ((ValidationResult)response).isInvalidNodeConfig()));
                    continue;
                }
                if (command instanceof NodesLeaveCommand) {
                    this.removeNodesFromLogicalTopology((NodesLeaveCommand)command);
                    this.onLogicalTopologyChanged.accept(clo.term());
                    clo.result(null);
                    continue;
                }
                if (command instanceof ChangeMetaStorageInfoCommand) {
                    this.changeMetastorageNodes((ChangeMetaStorageInfoCommand)command);
                    clo.result(null);
                    continue;
                }
                if (command instanceof RollingUpgradeStartCommand) {
                    this.rollingUpgradeStart((RollingUpgradeStartCommand)command);
                    clo.result(null);
                    continue;
                }
                if (command instanceof RollingUpgradeCommit) {
                    this.rollingUpgradeCommit((RollingUpgradeCommit)command);
                    clo.result(null);
                    continue;
                }
                if (!(command instanceof RollingUpgradeCancel)) continue;
                this.rollingUpgradeCancel((RollingUpgradeCancel)command);
                clo.result(null);
            }
            catch (Throwable e) {
                LOG.error("Unknown error while processing command [commandIndex={}, commandTerm={}, command={}]", e, clo.index(), clo.term(), clo.command());
                clo.result(e);
                throw e;
            }
        }
    }

    @Nullable
    private Serializable initCmgState(InitCmgStateCommand command) {
        ClusterState state = this.storageManager.getClusterState();
        if (state == null) {
            this.storageManager.putClusterState(command.clusterState());
            this.clusterIdStore.clusterId(command.clusterState().clusterTag().clusterId());
            return command.clusterState();
        }
        ValidationResult validationResult = ValidationManager.validateState(state, command.node().asClusterNode(), command.clusterState());
        return validationResult.isValid() ? state : new ValidationErrorResponse(validationResult.errorDescription(), validationResult.isInvalidNodeConfig());
    }

    private ValidationResult validateNode(JoinRequestCommand command) {
        Optional<LogicalNode> previousVersion = this.logicalTopology.getLogicalTopology().nodes().stream().filter(n -> n.name().equals(command.node().name())).findAny();
        if (previousVersion.isPresent()) {
            LogicalNode previousNode = previousVersion.get();
            if (previousNode.id().equals(command.node().id())) {
                return ValidationResult.successfulResult();
            }
            this.logicalTopology.removeNodes(Set.of(previousNode));
        }
        LogicalNode logicalNode = CmgRaftGroupListener.logicalNodeFromClusterNodeMessage(command.node());
        return this.validationManager.validateNode(this.storageManager.getClusterState(), logicalNode, command.igniteVersion(), command.clusterTag());
    }

    private ValidationResult completeValidation(JoinReadyCommand command) {
        ClusterNodeMessage clusterNodeMessage = command.node();
        LogicalNode logicalNode = CmgRaftGroupListener.logicalNodeFromClusterNodeMessage(clusterNodeMessage);
        if (this.validationManager.isNodeValidated(logicalNode)) {
            ValidationResult validationResponse = this.validationManager.completeValidation(logicalNode);
            if (validationResponse.isValid()) {
                this.logicalTopology.putNode(logicalNode);
            }
            return validationResponse;
        }
        return ValidationResult.errorResult(String.format("Node \"%s\" has not yet passed the validation step", clusterNodeMessage.asClusterNode()));
    }

    private static LogicalNode logicalNodeFromClusterNodeMessage(ClusterNodeMessage message) {
        InternalClusterNode node = message.asClusterNode();
        return new LogicalNode(node, Objects.requireNonNullElse(message.userAttributes(), Collections.emptyMap()), Objects.requireNonNullElse(message.systemAttributes(), Collections.emptyMap()), Objects.requireNonNullElse(message.storageProfiles(), Collections.emptyList()));
    }

    private void removeNodesFromLogicalTopology(NodesLeaveCommand command) {
        Set nodes = command.nodes().stream().map(ClusterNodeMessage::asClusterNode).collect(Collectors.toSet());
        Set<LogicalNode> logicalNodes = nodes.stream().map(n -> new LogicalNode((InternalClusterNode)n, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyList())).collect(Collectors.toSet());
        this.logicalTopology.removeNodes(logicalNodes);
        this.validationManager.removeValidatedNodes(logicalNodes);
        if (LOG.isInfoEnabled()) {
            LOG.info("Nodes removed from the logical topology [nodes={}]", nodes.stream().map(InternalClusterNode::name).collect(Collectors.toList()));
        }
    }

    private void changeMetastorageNodes(ChangeMetaStorageInfoCommand command) {
        ClusterState existingState = this.storageManager.getClusterState();
        assert (existingState != null) : "Cluster state was not initialized when got " + command;
        ClusterStateV2 newState = this.cmgMessagesFactory.clusterStateV2().cmgNodes(Set.copyOf(existingState.cmgNodes())).metaStorageNodes(Set.copyOf(command.metaStorageNodes())).version(existingState.version()).nextVersion(existingState instanceof ClusterStateV2 ? ((ClusterStateV2)existingState).nextVersion() : null).clusterTag(existingState.clusterTag()).initialClusterConfiguration(existingState.initialClusterConfiguration()).formerClusterIds(existingState.formerClusterIds()).build();
        this.storageManager.putClusterState(newState);
        if (command.metastorageRepairingConfigIndex() != null) {
            this.storageManager.saveMetastorageRepairInfo(command.metastorageRepairingConfigIndex());
        }
    }

    private void rollingUpgradeStart(RollingUpgradeStartCommand command) {
        LOG.info("Rolling upgrade started to version: {}", command.version());
        ClusterState existingState = this.storageManager.getClusterState();
        assert (existingState != null) : "Cluster state was not initialized when got " + command;
        ClusterStateV2 newState = this.clusterState(existingState, existingState.version(), command.version());
        this.clusterConfiguration.blockUpdates();
        this.storageManager.putClusterState(newState);
    }

    private void rollingUpgradeCommit(RollingUpgradeCommit command) {
        ClusterState existingState = this.storageManager.getClusterState();
        assert (existingState != null) : "Cluster state was not initialized when got " + command;
        assert (existingState instanceof ClusterStateV2);
        ClusterStateV2 existingStateV2 = (ClusterStateV2)existingState;
        LOG.info("Committing rolling upgrade from version {} to version {}", existingStateV2.version(), existingStateV2.nextVersion());
        assert (!CmgRaftGroupListener.checkUpgradeSupported(existingStateV2.version()) || existingStateV2.nextVersion() != null) : "Cluster state next version was not set when got " + command;
        String version = existingStateV2.nextVersion() != null ? existingStateV2.nextVersion() : IgniteProductVersion.CURRENT_VERSION.toString();
        ClusterStateV2 newState = this.cmgMessagesFactory.clusterStateV2().cmgNodes(Set.copyOf(existingStateV2.cmgNodes())).metaStorageNodes(existingStateV2.metaStorageNodes()).version(version).nextVersion(null).clusterTag(existingStateV2.clusterTag()).initialClusterConfiguration(existingStateV2.initialClusterConfiguration()).formerClusterIds(existingStateV2.formerClusterIds()).build();
        this.clusterConfiguration.unblockUpdates();
        this.storageManager.putClusterState(newState);
    }

    private void rollingUpgradeCancel(RollingUpgradeCancel command) {
        ClusterState existingState = this.storageManager.getClusterState();
        assert (existingState != null) : "Cluster state was not initialized when got " + command;
        assert (existingState instanceof ClusterStateV2);
        ClusterStateV2 existingStateV2 = (ClusterStateV2)existingState;
        LOG.info("Canceling rolling upgrade back to version {}", existingStateV2.version());
        assert (!CmgRaftGroupListener.checkUpgradeSupported(existingStateV2.version()) || existingStateV2.nextVersion() != null) : "Cluster state next version was not set when got " + command;
        ClusterStateV2 newState = this.clusterState(existingStateV2, existingStateV2.version(), null);
        this.clusterConfiguration.unblockUpdates();
        this.storageManager.putClusterState(newState);
    }

    private ClusterStateV2 clusterState(ClusterState existingState, String version, @Nullable String nextVersion) {
        return this.cmgMessagesFactory.clusterStateV2().cmgNodes(Set.copyOf(existingState.cmgNodes())).metaStorageNodes(Set.copyOf(existingState.metaStorageNodes())).version(version).nextVersion(nextVersion).clusterTag(existingState.clusterTag()).initialClusterConfiguration(existingState.initialClusterConfiguration()).formerClusterIds(existingState.formerClusterIds()).build();
    }

    private static boolean checkUpgradeSupported(String version) {
        return IgniteProductVersion.fromString(version).compareTo(VERSION_WITH_UPGRADE_SUPPORTED) >= 0;
    }

    @Override
    public void onSnapshotSave(Path path, Consumer<Throwable> doneClo) {
        this.storageManager.snapshot(path).whenComplete((unused, throwable) -> doneClo.accept((Throwable)throwable));
    }

    @Override
    public boolean onSnapshotLoad(Path path) {
        try {
            this.storageManager.restoreSnapshot(path);
            this.logicalTopology.fireTopologyLeap();
            return true;
        }
        catch (IgniteInternalException e) {
            this.failureProcessor.process(new FailureContext(e, String.format("Failed to restore snapshot [path=%s]", path)));
            return false;
        }
    }

    @Override
    public void onShutdown() {
        this.busyLock.block();
    }

    @TestOnly
    public ClusterStateStorageManager storageManager() {
        return this.storageManager;
    }
}

