/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cluster.management.network.messages;

import java.util.Objects;
import org.apache.ignite3.internal.cluster.management.network.messages.RefuseJoinMessage;
import org.apache.ignite3.internal.cluster.management.network.messages.RefuseJoinMessageBuilder;
import org.apache.ignite3.internal.cluster.management.network.messages.RefuseJoinMessageSerializer;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;

public class RefuseJoinMessageImpl
implements RefuseJoinMessage,
Cloneable {
    public static final short GROUP_TYPE = 7;
    public static final short TYPE = 8;
    @IgniteToStringInclude
    private final String reason;

    private RefuseJoinMessageImpl(String reason) {
        this.reason = reason;
    }

    @Override
    public String reason() {
        return this.reason;
    }

    public MessageSerializer serializer() {
        return RefuseJoinMessageSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 7;
    }

    public String toString() {
        return S.toString(RefuseJoinMessageImpl.class, this);
    }

    @Override
    public short messageType() {
        return 8;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        RefuseJoinMessageImpl otherMessage = (RefuseJoinMessageImpl)other;
        return Objects.equals(this.reason, otherMessage.reason);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.reason);
        return result;
    }

    @Override
    public RefuseJoinMessageImpl clone() {
        try {
            return (RefuseJoinMessageImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static RefuseJoinMessageBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements RefuseJoinMessageBuilder {
        private String reason;

        private Builder() {
        }

        @Override
        public RefuseJoinMessageBuilder reason(String reason) {
            Objects.requireNonNull(reason, "reason is not marked @Nullable");
            this.reason = reason;
            return this;
        }

        @Override
        public String reason() {
            return this.reason;
        }

        @Override
        public RefuseJoinMessage build() {
            return new RefuseJoinMessageImpl(Objects.requireNonNull(this.reason, "reason is not marked @Nullable"));
        }

        @Override
        public RefuseJoinMessage buildDeserialized() {
            return new RefuseJoinMessageImpl(this.reason);
        }
    }
}

