/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cluster.management;

import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite3.internal.cluster.management.ClusterStateV2;
import org.apache.ignite3.internal.cluster.management.ClusterStateV2Builder;
import org.apache.ignite3.internal.cluster.management.ClusterTag;
import org.apache.ignite3.internal.cluster.management.network.messages.CmgMessagesFactory;
import org.apache.ignite3.internal.cluster.management.network.messages.CmgMessagesTypeInfos;
import org.apache.ignite3.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;

class ClusterStateV2Deserializer
implements MessageDeserializer<ClusterStateV2> {
    private final ClusterStateV2Builder msg;

    ClusterStateV2Deserializer(CmgMessagesFactory messageFactory) {
        this.msg = messageFactory.clusterStateV2();
    }

    @Override
    public Class<ClusterStateV2> klass() {
        return ClusterStateV2.class;
    }

    @Override
    public ClusterStateV2 getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(CmgMessagesTypeInfos.clusterStateV2());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Object tmp = (ClusterTag)reader.readMessage("clusterTag");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.clusterTag((ClusterTag)tmp);
                }
                reader.incrementState();
            }
            case 1: {
                Object tmp = reader.readSet("cmgNodes", MessageCollectionItemType.STRING);
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.cmgNodes((Set<String>)tmp);
                }
                reader.incrementState();
            }
            case 2: {
                Object tmp = reader.readList("formerClusterIds", MessageCollectionItemType.UUID);
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.formerClusterIds((List<UUID>)tmp);
                }
                reader.incrementState();
            }
            case 3: {
                Object tmp = reader.readString("initialClusterConfiguration");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.initialClusterConfiguration((String)tmp);
                }
                reader.incrementState();
            }
            case 4: {
                Object tmp = reader.readSet("metaStorageNodes", MessageCollectionItemType.STRING);
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.metaStorageNodes((Set<String>)tmp);
                }
                reader.incrementState();
            }
            case 5: {
                Object tmp = reader.readString("nextVersion");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.nextVersion((String)tmp);
                }
                reader.incrementState();
            }
            case 6: {
                Object tmp = reader.readString("version");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.version((String)tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(ClusterStateV2.class);
    }
}

