/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.client.table;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.apache.ignite3.cache.CacheStore;
import org.apache.ignite3.cache.CacheStoreSession;
import org.apache.ignite3.cache.CacheWriteMode;
import org.apache.ignite3.internal.client.table.ClientSchema;
import org.apache.ignite3.internal.client.table.ClientTable;

public class InternalCacheStore<K, V>
implements CacheStore<K, V> {
    private final CacheStore<K, V> delegate;
    private final ClientTable table;

    InternalCacheStore(CacheStore<K, V> delegate, ClientTable table) {
        this.delegate = delegate;
        this.table = table;
        assert (table.cache());
    }

    public int tableId() {
        return this.table.tableId();
    }

    public CacheWriteMode cacheWriteMode() {
        return this.latestSchema().cacheWriteMode();
    }

    private ClientSchema latestSchema() {
        return this.table.getLatestSchema().join();
    }

    @Override
    public CacheStoreSession beginSession() {
        return this.delegate.beginSession();
    }

    @Override
    public CompletableFuture<V> loadAsync(K key) {
        return this.delegate.loadAsync(key);
    }

    @Override
    public CompletableFuture<Map<K, V>> loadAllAsync(Iterable<? extends K> keys) {
        return this.delegate.loadAllAsync(keys);
    }

    @Override
    public CompletableFuture<Void> writeAsync(CacheStoreSession session, Map.Entry<? extends K, ? extends V> entry) {
        return this.delegate.writeAsync(session, entry);
    }

    @Override
    public CompletableFuture<Void> writeAllAsync(CacheStoreSession session, Collection<Map.Entry<? extends K, ? extends V>> entries) {
        return this.delegate.writeAllAsync(session, entries);
    }

    @Override
    public CompletableFuture<Void> deleteAsync(CacheStoreSession session, K key) {
        return this.delegate.deleteAsync(session, key);
    }

    @Override
    public CompletableFuture<Void> deleteAllAsync(CacheStoreSession session, Collection<? extends K> keys) {
        return this.delegate.deleteAllAsync(session, keys);
    }

    @Override
    public CompletableFuture<Void> loadCacheAsync(BiConsumer<K, V> clo, Object ... args) {
        return this.delegate.loadCacheAsync(clo, args);
    }
}

