/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.client.structure;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.client.ReliableChannel;
import org.apache.ignite3.internal.client.table.ClientTable;
import org.apache.ignite3.internal.client.tx.ClientTransactions;
import org.apache.ignite3.internal.marshaller.MarshallersProvider;
import org.apache.ignite3.internal.util.ViewUtils;
import org.apache.ignite3.lang.IgniteExperimental;
import org.apache.ignite3.marshalling.Marshaller;
import org.apache.ignite3.sql.IgniteSql;
import org.apache.ignite3.table.QualifiedName;
import org.apache.ignite3.table.mapper.Mapper;
import org.gridgain.internal.structure.map.IgniteMapImpl;
import org.gridgain.structure.IgniteMap;
import org.gridgain.structure.IgniteStructures;
import org.gridgain.structure.MapConfiguration;
import org.gridgain.structure.StructureUtils;

@IgniteExperimental
public class ClientStructures
implements IgniteStructures {
    private final ReliableChannel ch;
    private final IgniteSql sql;
    private final MarshallersProvider marshallers;
    private final ClientTransactions transactions;
    private final int sqlPartitionAwarenessMetadataCacheSize;

    public ClientStructures(ReliableChannel ch, IgniteSql sql, MarshallersProvider marshallers, ClientTransactions transactions, int sqlPartitionAwarenessMetadataCacheSize) {
        this.ch = ch;
        this.sql = sql;
        this.marshallers = marshallers;
        this.transactions = transactions;
        this.sqlPartitionAwarenessMetadataCacheSize = sqlPartitionAwarenessMetadataCacheSize;
    }

    @Override
    public <K, V> CompletableFuture<IgniteMap<K, V>> getOrCreateMapAsync(MapConfiguration configuration) {
        return this.doGetOrCreateMapAsync(configuration);
    }

    @Override
    public <K, V> CompletableFuture<IgniteMap<K, V>> getOrCreateMapAsync(String name, Marshaller<K, byte[]> km, Marshaller<V, byte[]> vm) {
        return this.doGetOrCreateMapAsync(MapConfiguration.builder(name, km, vm).build());
    }

    @Override
    public <K, V> CompletableFuture<IgniteMap<K, V>> getOrCreateMapAsync(String name, Class<K> keyClass, Class<V> valueClass) {
        return this.doGetOrCreateMapAsync(MapConfiguration.builder(name, keyClass, valueClass).build());
    }

    @Override
    public <K, V> IgniteMap<K, V> getOrCreateMap(MapConfiguration configuration) {
        return ViewUtils.sync(this.getOrCreateMapAsync(configuration));
    }

    @Override
    public <K, V> IgniteMap<K, V> getOrCreateMap(String name, Marshaller<K, byte[]> keyMarshaller, Marshaller<V, byte[]> valueMarshaller) {
        return ViewUtils.sync(this.getOrCreateMapAsync(name, keyMarshaller, valueMarshaller));
    }

    @Override
    public <K, V> IgniteMap<K, V> getOrCreateMap(String name, Class<K> keyClass, Class<V> valueClass) {
        return ViewUtils.sync(this.getOrCreateMapAsync(name, keyClass, valueClass));
    }

    private <K, V> CompletableFuture<IgniteMap<K, V>> doGetOrCreateMapAsync(MapConfiguration conf) {
        Class keyClassKv = StructureUtils.nativeOrByteArray(conf.getKeyClass());
        Class valClassKv = StructureUtils.nativeOrByteArray(conf.getValueClass());
        return this.ch.serviceAsync(1007, w -> {
            w.out().packString(conf.getName().objectName());
            w.out().packString(keyClassKv.getName());
            w.out().packString(valClassKv.getName());
            w.out().packStringNullable(conf.getDistributionZone());
            w.out().packStringNullable(conf.getStorageProfile());
        }, r -> {
            QualifiedName mapName = r.in().unpackQualifiedName();
            QualifiedName tableName = r.in().unpackQualifiedName();
            int tableId = r.in().unpackInt();
            assert (Objects.equals(mapName.objectName(), conf.getName().objectName()));
            ClientTable table = new ClientTable(this.ch, this.marshallers, tableId, tableName, false, this.transactions, this.sqlPartitionAwarenessMetadataCacheSize);
            return new IgniteMapImpl(tableName.toCanonicalForm(), table.keyValueView(Mapper.of(keyClassKv), Mapper.of(valClassKv)), this.sql, StructureUtils.cast(conf.getKeyMarshaller()), StructureUtils.cast(conf.getValueMarshaller()));
        });
    }
}

