/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.client.proto;

import java.util.BitSet;
import java.util.Collection;
import java.util.EnumSet;

public enum ProtocolBitmaskFeature {
    USER_ATTRIBUTES(0),
    TABLE_GET_REQS_USE_QUALIFIED_NAME(1),
    TX_DIRECT_MAPPING(2),
    PLATFORM_COMPUTE_JOB(3),
    PLATFORM_COMPUTE_EXECUTOR(4),
    STREAMER_RECEIVER_EXECUTION_OPTIONS(5),
    TX_DELAYED_ACKS(6),
    TX_PIGGYBACK(7),
    TX_ALLOW_NOOP_ENLIST(8),
    SQL_PARTITION_AWARENESS(9),
    SQL_DIRECT_TX_MAPPING(10),
    COMPUTE_TASK_ID(11),
    TX_CLIENT_GETALL_SUPPORTS_TX_OPTIONS(12),
    SQL_MULTISTATEMENT_SUPPORT(13),
    CQ_EVENT_TYPE(128),
    CQ_PARTITION_SCAN_STATUS(129),
    CQ_SKIP_OLD_ENTRIES(130);

    private static final EnumSet<ProtocolBitmaskFeature> ALL_FEATURES_AS_ENUM_SET;
    private final int featureId;

    private ProtocolBitmaskFeature(int id) {
        this.featureId = id;
    }

    public int featureId() {
        return this.featureId;
    }

    public static EnumSet<ProtocolBitmaskFeature> enumSet(BitSet bitSet) {
        EnumSet<ProtocolBitmaskFeature> set = EnumSet.noneOf(ProtocolBitmaskFeature.class);
        for (ProtocolBitmaskFeature e : ProtocolBitmaskFeature.values()) {
            if (!bitSet.get(e.featureId())) continue;
            set.add(e);
        }
        return set;
    }

    public static BitSet featuresAsBitSet(Collection<ProtocolBitmaskFeature> features) {
        BitSet set = new BitSet();
        for (ProtocolBitmaskFeature f : features) {
            set.set(f.featureId());
        }
        return set;
    }

    public static EnumSet<ProtocolBitmaskFeature> allFeaturesAsEnumSet() {
        return ALL_FEATURES_AS_ENUM_SET.clone();
    }

    static {
        ALL_FEATURES_AS_ENUM_SET = EnumSet.allOf(ProtocolBitmaskFeature.class);
    }
}

