/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.core.style.component;

import org.apache.ignite3.internal.cli.core.style.AnsiStringSupport;
import org.apache.ignite3.internal.cli.core.style.component.UiComponent;
import org.apache.ignite3.internal.cli.core.style.element.UiElement;
import org.apache.ignite3.internal.cli.core.style.element.UiElements;
import org.apache.ignite3.internal.cli.core.style.element.UiString;
import org.apache.ignite3.internal.util.ArrayUtils;

public class QuestionUiComponent
implements UiComponent {
    private final String question;
    private final UiElement[] questionUiElements;

    private QuestionUiComponent(String question, UiElement[] questionUiElements) {
        this.question = question;
        this.questionUiElements = questionUiElements;
    }

    @Override
    public String render() {
        return AnsiStringSupport.ansi(UiString.format(this.question, this.questionUiElements));
    }

    public static QuestionUiComponent fromQuestion(String question, UiElement ... questionUiElements) {
        return QuestionUiComponent.builder().question(question, questionUiElements).build();
    }

    public static QuestionUiComponent fromYesNoQuestion(String question, UiElement ... questionUiElements) {
        return QuestionUiComponent.fromQuestion(question + " %s ", ArrayUtils.concat(questionUiElements, UiElements.yesNo()));
    }

    public static MessageComponentBuilder builder() {
        return new MessageComponentBuilder();
    }

    public static class MessageComponentBuilder {
        private String question;
        private UiElement[] questionUiElements;

        public MessageComponentBuilder question(String question, UiElement ... uiElements) {
            this.question = question;
            this.questionUiElements = uiElements;
            return this;
        }

        public QuestionUiComponent build() {
            return new QuestionUiComponent(this.question, this.questionUiElements);
        }
    }
}

