/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.commands.cluster.init;

import jakarta.inject.Inject;
import org.apache.ignite3.internal.cli.call.cluster.ClusterInitCallFactory;
import org.apache.ignite3.internal.cli.call.cluster.ClusterInitCallInput;
import org.apache.ignite3.internal.cli.commands.BaseCommand;
import org.apache.ignite3.internal.cli.commands.cluster.ClusterUrlMixin;
import org.apache.ignite3.internal.cli.commands.cluster.init.ClusterInitOptions;
import org.apache.ignite3.internal.cli.commands.cluster.init.ConfigAsPathException;
import org.apache.ignite3.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite3.internal.cli.core.call.AsyncCall;
import org.apache.ignite3.internal.cli.core.call.CallExecutionPipeline;
import org.apache.ignite3.internal.cli.core.call.ProgressTracker;
import org.apache.ignite3.internal.cli.core.flow.builder.FlowBuilder;
import org.apache.ignite3.internal.cli.core.flow.builder.Flows;
import org.apache.ignite3.internal.cli.core.repl.ConnectionHeartBeat;
import org.apache.ignite3.internal.cli.core.style.component.QuestionUiComponent;
import org.apache.ignite3.internal.cli.core.style.element.UiElement;
import picocli.CommandLine;

@CommandLine.Command(name="init", description={"Initializes an Ignite cluster"})
public class ClusterInitReplCommand
extends BaseCommand
implements Runnable {
    @CommandLine.Mixin
    private ClusterUrlMixin clusterUrl;
    @CommandLine.Mixin
    private ClusterInitOptions clusterInitOptions;
    @Inject
    private ClusterInitCallFactory callFactory;
    @Inject
    private ConnectToClusterQuestion question;
    @Inject
    private ConnectionHeartBeat connectionHeartBeat;

    @Override
    public void run() {
        this.runFlow(this.question.askQuestionIfNotConnected(this.clusterUrl.getClusterUrl()).then(this.askQuestionIfConfigIsPath().build()).then(Flows.mono(this::runAsync)));
    }

    private FlowBuilder<String, ClusterInitCallInput> askQuestionIfConfigIsPath() {
        try {
            this.clusterInitOptions.clusterConfiguration();
            return Flows.from(this::buildCallInput);
        }
        catch (ConfigAsPathException e) {
            QuestionUiComponent questionUiComponent = QuestionUiComponent.fromYesNoQuestion("It seems that you have passed the path to the configuration file in the configuration content --config option. Do you want to read cluster configuration from this file?", new UiElement[0]);
            return Flows.acceptQuestion(questionUiComponent, clusterUrl -> ClusterInitCallInput.builder().clusterConfiguration(this.clusterInitOptions.readConfigAsPath()).cmgNodes(this.clusterInitOptions.cmgNodes()).metaStorageNodes(this.clusterInitOptions.metaStorageNodes()).clusterName(this.clusterInitOptions.clusterName()).clusterUrl((String)clusterUrl).build());
        }
    }

    private ClusterInitCallInput buildCallInput(String clusterUrl) {
        return ClusterInitCallInput.builder().clusterUrl(clusterUrl).fromClusterInitOptions(this.clusterInitOptions).build();
    }

    private int runAsync(ClusterInitCallInput input) {
        return this.runPipeline(CallExecutionPipeline.asyncBuilder(this::createCall).inputProvider(() -> input).enableSpinner("Initializing").updateIntervalMillis(500));
    }

    private AsyncCall<ClusterInitCallInput, String> createCall(ProgressTracker tracker) {
        AsyncCall<ClusterInitCallInput, String> delegate = this.callFactory.create(tracker);
        return input -> delegate.execute((ClusterInitCallInput)input).whenComplete((output, throwable) -> this.connectionHeartBeat.pingConnection());
    }
}

