/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.commands;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum Options {
    CLUSTER_URL("--url", "URL of cluster endpoint. It can be any node URL.If not set, then the default URL from the profile settings will be used"),
    NODE_URL("--url", "URL of a node that will be used as a communication endpoint. It can be any node URL. If not set, then the default URL from the profile settings will be used"),
    CLUSTER_NAME("--name", "Human-readable name of the cluster"),
    NODE_NAME("--node", "-n", "The name of the node to perform the operation on. Node names can be seen in the output of the 'cluster topology' command"),
    CMG_NODE_NAME("--cluster-management-group", "Names of nodes (use comma-separated list of node names '--cluster-management-group node1, node2' to specify more than one node) that will host the Cluster Management Group. If omitted, then --metastorage-group values will also supply the nodes for the Cluster Management Group."),
    META_STORAGE_NODE_NAME("--metastorage-group", "Metastorage group nodes (use comma-separated list of node names '--metastorage-group node1, node2' to specify more than one node) that will host the Meta Storage. If the --cluster-management-group option is omitted, the same nodes will also host the Cluster Management Group."),
    PROFILE("--profile", "Local CLI profile name. Profile stores useful settings like default cluster URL, jdbc URL, etc"),
    PROFILE_COPY_FROM("--copy-from", "Profile whose content will be copied to new one"),
    PROFILE_ACTIVATE("--activate", "Activate new profile as current or not. By activating a profile, you set profile settings for the current session"),
    SCRIPT_FILE("--file", "Path to file with SQL commands to execute"),
    JDBC_URL("--jdbc-url", "JDBC url to ignite cluster. For example, 'jdbc:ignite:thin://127.0.0.1:10800'"),
    UNIT_PATH("--path", "Path to deployment unit file or directory"),
    UNIT_VERSION("--version", "Unit version (x.y.z)"),
    UNIT_NODES("--nodes", "--nodes", "Initial set of nodes where the unit will be deployed"),
    PLAIN("--plain", "--plain", "Display output with plain formatting. Might be useful if you want to pipe the output to another command"),
    VERBOSE("--verbose", "-v", "Show additional information: logs, REST calls. This flag is useful for debugging. Specify multiple options to increase verbosity for REST calls. Single option shows request and response, second option (-vv) shows headers, third one (-vvv) shows body"),
    HELP("--help", "-h", "Show help for the specified command"),
    VERSION("--version", "--version", "Print version information"),
    CLUSTER_CONFIG("--config", "Cluster configuration that will be applied during the cluster initialization"),
    CLUSTER_CONFIG_FILE("--config-files", "Path to cluster configuration files (use comma-separated list of paths '--config-files path1, path2' to specify more than one file)"),
    RECOVERY_NODE_NAMES("--nodes", "Names specifying nodes to get partition states from. Case-sensitive, without quotes, all nodes if not set"),
    RECOVERY_CMG_NODES("--cluster-management-group", "Names of nodes (use comma-separated list of node names '--cluster-management-group node1, node2' to specify more than one node) that will host the Cluster Management Group.");

    private final String fullName;
    private final String shortName;
    private final String description;

    private Options(String fullName, String shortName, String description) {
        this.fullName = fullName;
        this.shortName = shortName;
        this.description = description;
    }

    private Options(String fullName, String description) {
        this.fullName = fullName;
        this.shortName = fullName;
        this.description = description;
    }

    public String fullName() {
        return this.fullName;
    }

    public String shortName() {
        return this.shortName;
    }

    public Set<String> names() {
        return Stream.of(this.fullName, this.shortName).collect(Collectors.toSet());
    }

    public String description() {
        return this.description;
    }

    public static final class Constants {
        public static final String CLUSTER_URL_OPTION = "--url";
        public static final String CLUSTER_URL_OPTION_DESC = "URL of cluster endpoint. It can be any node URL.If not set, then the default URL from the profile settings will be used";
        public static final String CLUSTER_URL_KEY = "ignite.cluster-endpoint-url";
        public static final String NODE_URL_OPTION = "--url";
        public static final String NODE_URL_OPTION_DESC = "URL of a node that will be used as a communication endpoint. It can be any node URL. If not set, then the default URL from the profile settings will be used";
        public static final String PROFILE_OPTION = "--profile";
        public static final String PROFILE_OPTION_DESC = "Local CLI profile name. Profile stores useful settings like default cluster URL, jdbc URL, etc";
        public static final String NODE_NAME_OPTION = "--node";
        public static final String NODE_NAME_OPTION_SHORT = "-n";
        public static final String NODE_NAME_OPTION_DESC = "The name of the node to perform the operation on. Node names can be seen in the output of the 'cluster topology' command";
        public static final String VERBOSE_OPTION = "--verbose";
        public static final String VERBOSE_OPTION_SHORT = "-v";
        public static final String VERBOSE_OPTION_DESC = "Show additional information: logs, REST calls. This flag is useful for debugging. Specify multiple options to increase verbosity for REST calls. Single option shows request and response, second option (-vv) shows headers, third one (-vvv) shows body";
        public static final String HELP_OPTION = "--help";
        public static final String HELP_OPTION_SHORT = "-h";
        public static final String HELP_OPTION_DESC = "Show help for the specified command";
        public static final String PROFILE_COPY_FROM_OPTION = "--copy-from";
        public static final String PROFILE_COPY_FROM_OPTION_DESC = "Profile whose content will be copied to new one";
        public static final String PROFILE_ACTIVATE_OPTION = "--activate";
        public static final String PROFILE_ACTIVATE_OPTION_DESC = "Activate new profile as current or not. By activating a profile, you set profile settings for the current session";
        public static final String CMG_NODE_NAME_OPTION = "--cluster-management-group";
        public static final String CMG_NODE_NAME_PARAM_LABEL = "<node name>";
        public static final String CMG_NODE_NAME_OPTION_DESC = "Names of nodes (use comma-separated list of node names '--cluster-management-group node1, node2' to specify more than one node) that will host the Cluster Management Group. If omitted, then --metastorage-group values will also supply the nodes for the Cluster Management Group.";
        public static final String META_STORAGE_NODE_NAME_OPTION = "--metastorage-group";
        public static final String META_STORAGE_NODE_NAME_PARAM_LABEL = "<node name>";
        public static final String META_STORAGE_NODE_NAME_OPTION_DESC = "Metastorage group nodes (use comma-separated list of node names '--metastorage-group node1, node2' to specify more than one node) that will host the Meta Storage. If the --cluster-management-group option is omitted, the same nodes will also host the Cluster Management Group.";
        public static final String CLUSTER_NAME_OPTION = "--name";
        public static final String CLUSTER_NAME_OPTION_DESC = "Human-readable name of the cluster";
        public static final String PLAIN_OPTION = "--plain";
        public static final String PLAIN_OPTION_DESC = "Display output with plain formatting. Might be useful if you want to pipe the output to another command";
        public static final String JDBC_URL_OPTION = "--jdbc-url";
        public static final String JDBC_URL_OPTION_DESC = "JDBC url to ignite cluster. For example, 'jdbc:ignite:thin://127.0.0.1:10800'";
        public static final String JDBC_URL_KEY = "ignite.jdbc-url";
        public static final String SCRIPT_FILE_OPTION = "--file";
        public static final String SCRIPT_FILE_OPTION_DESC = "Path to file with SQL commands to execute";
        public static final String VERSION_OPTION = "--version";
        public static final String VERSION_OPTION_DESC = "Print version information";
        public static final String UNIT_VERSION_OPTION_DESC = "Unit version (x.y.z)";
        public static final String UNIT_PATH_OPTION = "--path";
        public static final String UNIT_PATH_OPTION_DESC = "Path to deployment unit file or directory";
        public static final String UNIT_NODES_OPTION = "--nodes";
        public static final String UNIT_NODES_OPTION_DESC = "Initial set of nodes where the unit will be deployed";
        public static final String CLUSTER_CONFIG_OPTION = "--config";
        public static final String CLUSTER_CONFIG_OPTION_DESC = "Cluster configuration that will be applied during the cluster initialization";
        public static final String CLUSTER_CONFIG_FILE_OPTION = "--config-files";
        public static final String CLUSTER_CONFIG_FILE_OPTION_DESC = "Path to cluster configuration files (use comma-separated list of paths '--config-files path1, path2' to specify more than one file)";
        public static final String CLUSTER_CONFIG_FILE_PARAM_LABEL = "<file path>";
        public static final String PASSWORD_OPTION = "--password";
        public static final String PASSWORD_OPTION_SHORT = "-p";
        public static final String PASSWORD_OPTION_DESC = "Password to connect to cluster";
        public static final String USERNAME_OPTION = "--username";
        public static final String USERNAME_OPTION_SHORT = "-u";
        public static final String USERNAME_OPTION_DESC = "Username to connect to cluster";
        public static final String TOKEN_OPTION = "--token";
        public static final String TABLES_OPTION = "--tables";
        public static final String STRUCTURES_OPTION = "--structures";
        public static final String FORCE_OPTION = "--force";
        public static final String ALL_OPTION = "--all";
        public static final String TABLES_OPTION_SNAPSHOT_CREATE_DESC = "Comma-separated fully-qualified table names that will be parts of the snapshot. Incompatible with --all";
        public static final String STRUCTURES_OPTION_SNAPSHOT_CREATE_DESC = "Comma-separated fully-qualified structure names that will be parts of the snapshot. Incompatible with --all";
        public static final String TABLES_OPTION_RECOVERY_DESC = "Comma-separated fully-qualified table names that will be recovered";
        public static final String STRUCTURES_OPTION_SNAPSHOT_RECOVERY_DESC = "Comma-separated fully-qualified structure names that will be recovered.";
        public static final String FORCE_OPTION_SNAPSHOT_RESTORE_DESC = "If false, snapshot restoration will fail if structures (included in the snapshot) already exist. If true, structures will be overwritten. It can cause duplicates in values generated using sequences";
        public static final String TABLES_OPTION_SNAPSHOT_RESTORE_DESC = "Comma-separated fully-qualified table names to restore from the snapshot";
        public static final String TABLES_OPTION_REPLICATION_DESC = "Comma-separated table names that should be replicated. Incompatible with --all";
        public static final String ALL_OPTION_SNAPSHOT_DESC = "Create snapshot of all tables. Incompatible with --tables";
        public static final String ALL_OPTION_REPLICATION_DESC = "Replicate all tables. Incompatible with --tables";
        public static final String SNAPSHOT_TYPE_OPTION = "--type";
        public static final String SNAPSHOT_TYPE_OPTION_DESC = "Type of the snapshot to create. Possible values: 'full', 'incremental'";
        public static final String SNAPSHOT_DESTINATION_OPTION = "--destination";
        public static final String SNAPSHOT_DESTINATION_OPTION_DESC = "Name of the snapshot URI in configuration";
        public static final String SNAPSHOT_SOURCE_OPTION = "--source";
        public static final String SNAPSHOT_SOURCE_OPTION_DESC = "Name of the snapshot URI in configuration";
        public static final String TIMESTAMP_OPTION = "--timestamp";
        public static final String TIMESTAMP_OPTION_DESC = "Timestamp to create snapshot at in the ISO-8601 format. For example: 1970-01-01T00:00:00Z. Current time is used if not provided";
        public static final String ID_OPTION = "--id";
        public static final String SNAPSHOT_ID_DESCRIPTION = "ID of the snapshot";
        public static final String RECOVERY_OPERATION_ID_DESCRIPTION = "ID of the recovery operation";
        public static final String OPERATION_ID_DESCRIPTION = "ID of the operation";
        public static final String SNAPSHOT_ALL_NODES_OPTION = "--all-nodes";
        public static final String SNAPSHOT_ALL_NODES_DESCRIPTION = "Optional flag that modifies the output to contain every status of all nodes that participate in the snapshot operation";
        public static final String SNAPSHOT_SHOW_TABLES_OPTION = "--show-tables";
        public static final String SNAPSHOT_SHOW_TABLES_DESCRIPTION = "Optional flag that modifies the output to contain table names that participate in snapshot creation or restoration";
        public static final String SNAPSHOT_ENCRYPTION_PROVIDER_OPTION = "--encryption-provider";
        public static final String SNAPSHOT_ENCRYPTION_PROVIDER_OPTION_DESC = "Name of the encryption provider";
        public static final String SNAPSHOT_DECRYPTION_PROVIDER_OPTION = "--decryption-provider";
        public static final String SNAPSHOT_DECRYPTION_PROVIDER_OPTION_DESC = "Name of the decryption provider";
        public static final String RECOVERY_PARTITION_GLOBAL_OPTION = "--global";
        public static final String RECOVERY_PARTITION_GLOBAL_OPTION_DESC = "Get global partitions states";
        public static final String RECOVERY_PARTITION_LOCAL_OPTION = "--local";
        public static final String RECOVERY_PARTITION_LOCAL_OPTION_DESC = "Get local partition states";
        public static final String RECOVERY_PARTITION_IDS_OPTION = "--partitions";
        public static final String RECOVERY_PARTITION_IDS_OPTION_DESC = "IDs of partitions to get states. All partitions if not set";
        public static final String RECOVERY_ZONE_NAMES_OPTION = "--zones";
        public static final String RECOVERY_ZONE_NAMES_OPTION_DESC = "Names specifying zones to get partition states from. Case-sensitive, without quotes, all zones if not set";
        public static final String RECOVERY_ZONE_NAME_OPTION = "--zone";
        public static final String RECOVERY_ZONE_NAME_OPTION_DESC = "Name of the zone to reset partitions of. Case-sensitive, without quotes";
        public static final String RECOVERY_TABLE_NAME_OPTION = "--table";
        public static final String RECOVERY_TABLE_NAME_OPTION_DESC = "Fully-qualified name of the table to reset partitions of. Case-sensitive, without quotes";
        public static final String RECOVERY_TABLE_TIMESTAMP_DESC = "Timestamp to create snapshot at in the ISO-8601 format. For example: 1970-01-01T00:00:00Z";
        public static final String RECOVERY_NODE_NAMES_OPTION = "--nodes";
        public static final String RECOVERY_NODE_NAMES_OPTION_DESC = "Names specifying nodes to get partition states from. Case-sensitive, without quotes, all nodes if not set";
        public static final String RECOVERY_METASTORAGE_REPLICATION_OPTION = "--metastorage-replication-factor";
        public static final String RECOVERY_METASTORAGE_REPLICATION_DESC = "Number of nodes in the voting member set of the Metastorage RAFT group.";
        public static final String RECOVERY_CMG_NODES_OPTION = "--cluster-management-group";
        public static final String RECOVERY_CMG_NODES_OPTION_DESC = "Names of nodes (use comma-separated list of node names '--cluster-management-group node1, node2' to specify more than one node) that will host the Cluster Management Group.";
        public static final String RECOVERY_WITH_CLEANUP_OPTION = "--with-cleanup";
        public static final String RECOVERY_WITH_CLEANUP_OPTION_DESC = "Restarts partitions, preceded by a storage cleanup. This will remove all data from the partition storages before restart.";
        public static final String RECOVERY_OLD_CLUSTER_URL_OPTION = "--old-cluster-url";
        public static final String RECOVERY_OLD_CLUSTER_URL_OPTION_DESC = "URL of old cluster endpoint (nodes of this cluster will be migrated to a new cluster). It can be URL of any node of the old cluster.";
        public static final String RECOVERY_NEW_CLUSTER_URL_OPTION = "--new-cluster-url";
        public static final String RECOVERY_NEW_CLUSTER_URL_OPTION_DESC = "URL of new cluster endpoint (nodes of old cluster will be migrated to this cluster). It can be URL of any node of the new cluster.";
        public static final String CONFIG_FORMAT_OPTION = "--format";
        public static final String CONFIG_FORMAT_OPTION_DESC = "Output format. Valid values: ${COMPLETION-CANDIDATES}";
        public static final String CONFIG_UPDATE_FILE_OPTION = "--file";
        public static final String CONFIG_UPDATE_FILE_OPTION_DESC = "Path to file with config update commands to execute";
        public static final String DISTRIBUTION_ZONE_NAMES_OPTION = "--zones";
        public static final String DISTRIBUTION_ZONE_NAMES_OPTION_DESC = "Names specifying zones to reset the distribution state in, as if the table/zone was just created.";
        public static final String RESET_DATA_NODES_ZONE_NAMES_OPTION = "--zone-names";
        public static final String RESET_DATA_NODES_ZONE_NAMES_OPTION_DESC = "Comma-separated list of zone names to reset data nodes for. If not specified, resets for all zones.";
    }
}

