/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.call.connect;

import io.micronaut.http.HttpStatus;
import jakarta.inject.Singleton;
import org.apache.ignite3.internal.cli.call.connect.ConnectCallInput;
import org.apache.ignite3.internal.cli.call.connect.ConnectSuccessCall;
import org.apache.ignite3.internal.cli.call.connect.ConnectionChecker;
import org.apache.ignite3.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite3.internal.cli.config.ConfigManagerProvider;
import org.apache.ignite3.internal.cli.core.call.Call;
import org.apache.ignite3.internal.cli.core.call.CallOutput;
import org.apache.ignite3.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite3.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite3.internal.cli.core.exception.IgniteCliException;
import org.apache.ignite3.internal.cli.core.repl.Session;
import org.apache.ignite3.internal.cli.core.repl.SessionInfo;
import org.apache.ignite3.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite3.internal.cli.core.rest.ApiClientSettings;
import org.apache.ignite3.internal.cli.core.rest.TokenStore;
import org.apache.ignite3.internal.cli.core.style.component.MessageUiComponent;
import org.apache.ignite3.internal.cli.core.style.element.UiElements;
import org.apache.ignite3.internal.cli.event.EventPublisher;
import org.apache.ignite3.internal.cli.event.Events;
import org.apache.ignite3.internal.util.StringUtils;
import org.apache.ignite3.rest.client.invoker.ApiException;
import org.jetbrains.annotations.Nullable;

@Singleton
public class ConnectCall
implements Call<ConnectCallInput, String> {
    private final Session session;
    private final ApiClientFactory clientFactory;
    private final EventPublisher eventPublisher;
    private final ConnectSuccessCall connectSuccessCall;
    private final ConnectionChecker connectionChecker;
    private final ConfigManagerProvider configManagerProvider;
    private final TokenStore tokenStore;

    public ConnectCall(Session session, ApiClientFactory clientFactory, EventPublisher eventPublisher, ConnectSuccessCall connectSuccessCall, ConnectionChecker connectionChecker, ConfigManagerProvider configManagerProvider, TokenStore tokenStore) {
        this.session = session;
        this.clientFactory = clientFactory;
        this.eventPublisher = eventPublisher;
        this.connectSuccessCall = connectSuccessCall;
        this.connectionChecker = connectionChecker;
        this.configManagerProvider = configManagerProvider;
        this.tokenStore = tokenStore;
    }

    @Override
    public CallOutput<String> execute(ConnectCallInput input) {
        String nodeUrl = input.url();
        try {
            SessionInfo currentSessionInfo = this.session.info();
            SessionInfo sessionInfo = this.connectWithoutAuthentication(input);
            if (currentSessionInfo != null && currentSessionInfo.equals(sessionInfo)) {
                MessageUiComponent message = MessageUiComponent.fromMessage("You are already connected to %s", UiElements.url(nodeUrl));
                return DefaultCallOutput.success(message.render());
            }
            if (sessionInfo == null) {
                sessionInfo = this.connectionChecker.checkConnection(input);
                if (!StringUtils.nullOrBlank(input.username()) && !StringUtils.nullOrBlank(input.password())) {
                    ApiClientSettings clientSettings = ApiClientSettings.builder().basicAuthenticationUsername(input.username()).basicAuthenticationPassword(input.password()).build();
                    this.clientFactory.setSessionSettings(clientSettings);
                }
            } else if (!StringUtils.nullOrBlank(input.username()) || !StringUtils.nullOrBlank(input.password())) {
                return DefaultCallOutput.failure(ConnectCall.handleException(new IgniteCliException("Authentication is not enabled on cluster but username or password were provided."), sessionInfo.nodeUrl()));
            }
            ConnectToClusterQuestion.askQuestionToStoreCredentials(this.configManagerProvider.get(), this.tokenStore, input.username(), input.password());
            return this.connectSuccessCall.execute(sessionInfo, input.checkClusterInit());
        }
        catch (Exception e) {
            if (this.session.info() != null) {
                this.eventPublisher.publish(Events.disconnect());
            }
            return DefaultCallOutput.failure(ConnectCall.handleException(e, nodeUrl));
        }
    }

    @Nullable
    private SessionInfo connectWithoutAuthentication(ConnectCallInput connectCallInput) throws ApiException {
        try {
            return this.connectionChecker.checkConnectionWithoutAuthentication(connectCallInput);
        }
        catch (ApiException e) {
            if (e.getCause() == null && e.getCode() == HttpStatus.UNAUTHORIZED.getCode()) {
                return null;
            }
            throw e;
        }
    }

    private static IgniteCliApiException handleException(Exception e, String nodeUrl) {
        if (e instanceof IgniteCliApiException) {
            return (IgniteCliApiException)e;
        }
        return new IgniteCliApiException(e, nodeUrl);
    }
}

