/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.call.cluster;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.cli.call.cluster.ClusterInitCallInput;
import org.apache.ignite3.internal.cli.core.call.AsyncCall;
import org.apache.ignite3.internal.cli.core.call.CallOutput;
import org.apache.ignite3.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite3.internal.cli.core.call.ProgressTracker;
import org.apache.ignite3.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite3.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite3.rest.client.api.ClusterManagementApi;
import org.apache.ignite3.rest.client.invoker.ApiClient;
import org.apache.ignite3.rest.client.invoker.ApiException;
import org.apache.ignite3.rest.client.model.InitCommand;

public class ClusterInitCall
implements AsyncCall<ClusterInitCallInput, String> {
    private final ProgressTracker tracker;
    private final ApiClientFactory clientFactory;
    private static final int READ_TIMEOUT_MILLIS = 60000;

    ClusterInitCall(ProgressTracker tracker, ApiClientFactory clientFactory) {
        this.tracker = tracker;
        this.clientFactory = clientFactory;
    }

    @Override
    public CompletableFuture<CallOutput<String>> execute(ClusterInitCallInput input) {
        ClusterManagementApi client = this.createApiClient(input);
        this.tracker.maxSize(-1L);
        return CompletableFuture.supplyAsync(() -> {
            try {
                client.init(new InitCommand().metaStorageNodes(input.getMetaStorageNodes()).cmgNodes(input.getCmgNodes()).clusterName(input.getClusterName()).clusterConfiguration(input.clusterConfiguration()).license(input.getLicense()));
                DefaultCallOutput<String> defaultCallOutput = DefaultCallOutput.success("Cluster was initialized successfully.");
                return defaultCallOutput;
            }
            catch (IllegalArgumentException | ApiException e) {
                DefaultCallOutput defaultCallOutput = DefaultCallOutput.failure(new IgniteCliApiException(e, input.getClusterUrl()));
                return defaultCallOutput;
            }
            finally {
                this.tracker.done();
            }
        });
    }

    private ClusterManagementApi createApiClient(ClusterInitCallInput input) {
        ApiClient client = this.clientFactory.getClient(input.getClusterUrl());
        client.setReadTimeout(60000);
        return new ClusterManagementApi(client);
    }
}

