/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.systemviews;

import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.CatalogSystemViewProvider;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSequenceDescriptor;
import org.apache.ignite3.internal.systemview.api.ClusterSystemView;
import org.apache.ignite3.internal.systemview.api.SystemView;
import org.apache.ignite3.internal.systemview.api.SystemViews;
import org.apache.ignite3.internal.type.NativeTypes;
import org.apache.ignite3.internal.util.SubscriptionUtils;

public class SequencesSystemViewProvider
implements CatalogSystemViewProvider {
    @Override
    public List<SystemView<?>> getView(Supplier<Catalog> catalogSupplier) {
        Iterable data = () -> {
            Catalog catalog = (Catalog)catalogSupplier.get();
            return catalog.sequences().stream().filter(Objects::nonNull).map(sequence -> new SequenceWithCatalog((CatalogSequenceDescriptor)sequence, catalog)).iterator();
        };
        SystemView sequencesView = ((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)SystemViews.clusterViewBuilder().name("SEQUENCES")).addColumn("SEQUENCE_ID", NativeTypes.INT32, v -> v.descriptor.id())).addColumn("SEQUENCE_NAME", NativeTypes.STRING, v -> v.descriptor.name())).addColumn("SEQUENCE_DATA_TYPE", NativeTypes.STRING, v -> "BIGINT")).addColumn("SEQUENCE_INCREMENT", NativeTypes.INT64, v -> v.descriptor.increment())).addColumn("SEQUENCE_MINIMUM_VALUE", NativeTypes.INT64, v -> v.descriptor.minvalue())).addColumn("SEQUENCE_MAXIMUM_VALUE", NativeTypes.INT64, v -> v.descriptor.maxvalue())).addColumn("SEQUENCE_START_VALUE", NativeTypes.INT64, v -> v.descriptor.start())).addColumn("SEQUENCE_CACHE_VALUE", NativeTypes.INT64, v -> v.descriptor.cachevalue())).addColumn("ID", NativeTypes.INT32, v -> v.descriptor.id())).addColumn("NAME", NativeTypes.STRING, v -> v.descriptor.name())).addColumn("SCHEMA_ID", NativeTypes.INT32, v -> v.descriptor.schemaId())).addColumn("SCHEMA_NAME", NativeTypes.STRING, v -> v.catalog.schema(v.descriptor.schemaId()).name())).addColumn("DATA_TYPE", NativeTypes.STRING, v -> "BIGINT")).addColumn("INCREMENT", NativeTypes.INT64, v -> v.descriptor.increment())).addColumn("MINIMUM_VALUE", NativeTypes.INT64, v -> v.descriptor.minvalue())).addColumn("MAXIMUM_VALUE", NativeTypes.INT64, v -> v.descriptor.maxvalue())).addColumn("START_VALUE", NativeTypes.INT64, v -> v.descriptor.start())).addColumn("CACHE_VALUE", NativeTypes.INT64, v -> v.descriptor.cachevalue())).dataProvider(SubscriptionUtils.fromIterable(data))).build();
        return List.of(sequencesView);
    }

    private static class SequenceWithCatalog {
        final CatalogSequenceDescriptor descriptor;
        final Catalog catalog;

        SequenceWithCatalog(CatalogSequenceDescriptor descriptor, Catalog catalog) {
            this.descriptor = descriptor;
            this.catalog = catalog;
        }
    }
}

