/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.storage.serialization;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogEntrySerializerProvider;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogSerializer;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogSerializerTypeDefinition;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogVersionAwareSerializer;
import org.apache.ignite3.internal.catalog.storage.serialization.MarshallableEntry;
import org.apache.ignite3.internal.lang.IgniteStringFormatter;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;

public class CatalogEntrySerializerProviderImpl
implements CatalogEntrySerializerProvider {
    public static final int BASE_VERSION = 2;
    private final int baseVersion;
    private final Int2ObjectMap<CatalogVersionAwareSerializer<? extends MarshallableEntry>[]> serializers;

    CatalogEntrySerializerProviderImpl(List<CatalogSerializerTypeDefinition> serializerTypes) {
        this(serializerTypes, 2);
    }

    CatalogEntrySerializerProviderImpl(List<CatalogSerializerTypeDefinition> serializerTypes, int baseVersion) {
        this.baseVersion = baseVersion;
        SerializerRegistryBuilder registryBuilder = new SerializerRegistryBuilder(baseVersion, serializerTypes, this);
        try {
            this.serializers = registryBuilder.build();
        }
        catch (Throwable t) {
            IgniteLogger logger = Loggers.forClass(CatalogEntrySerializerProviderImpl.class);
            logger.error("Failed to build serializer registry.", t);
            throw t;
        }
    }

    public <T extends MarshallableEntry> CatalogVersionAwareSerializer<T> get(int version, int typeId) {
        CatalogVersionAwareSerializer<? extends MarshallableEntry>[] serializersArray = this.serializerOrThrow(typeId);
        int index = version - this.baseVersion;
        if (version <= 0) {
            throw new IllegalArgumentException("Serializer version must be positive [version=" + version + "].");
        }
        if (index >= serializersArray.length) {
            throw new IllegalArgumentException("Required serializer version not found [version=" + version + "].");
        }
        return serializersArray[index];
    }

    @Override
    public int latestSerializerVersion(int typeId) {
        CatalogVersionAwareSerializer<? extends MarshallableEntry>[] serializers = this.serializerOrThrow(typeId);
        return serializers[serializers.length - 1].version();
    }

    private CatalogVersionAwareSerializer<? extends MarshallableEntry>[] serializerOrThrow(int typeId) {
        CatalogVersionAwareSerializer[] serializersArray = (CatalogVersionAwareSerializer[])this.serializers.get(typeId);
        if (serializersArray == null) {
            throw new IllegalArgumentException("Unknown type ID: " + typeId);
        }
        return serializersArray;
    }

    private static class SerializerRegistryBuilder {
        private final int baseVersion;
        private final CatalogEntrySerializerProvider provider;
        private final List<CatalogSerializerTypeDefinition> serializerTypes;

        SerializerRegistryBuilder(int baseVersion, List<CatalogSerializerTypeDefinition> serializerTypes, CatalogEntrySerializerProvider provider) {
            this.baseVersion = baseVersion;
            this.serializerTypes = serializerTypes;
            this.provider = provider;
        }

        Int2ObjectMap<CatalogVersionAwareSerializer<? extends MarshallableEntry>[]> build() {
            Int2ObjectMap<List<CatalogVersionAwareSerializer<? extends MarshallableEntry>>> mapByType = this.mapSerializersByType();
            Int2ObjectMap<CatalogVersionAwareSerializer<? extends MarshallableEntry>[]> resultMap = SerializerRegistryBuilder.remapToOrderedArray(this.baseVersion, mapByType);
            return Int2ObjectMaps.unmodifiable(resultMap);
        }

        private Int2ObjectMap<List<CatalogVersionAwareSerializer<? extends MarshallableEntry>>> mapSerializersByType() {
            Int2ObjectOpenHashMap result = new Int2ObjectOpenHashMap();
            for (CatalogSerializerTypeDefinition type : this.serializerTypes) {
                Class<?> containerClass = type.container();
                assert (containerClass != null) : type;
                boolean atLeastSingleSerializerExists = false;
                for (Class<?> clazz : containerClass.getDeclaredClasses()) {
                    CatalogSerializer ann = clazz.getAnnotation(CatalogSerializer.class);
                    if (ann == null) continue;
                    if (!CatalogObjectSerializer.class.isAssignableFrom(clazz)) {
                        throw new IllegalStateException(IgniteStringFormatter.format("The target class doesn't implement the required interface [class={}, interface={}].", clazz.getCanonicalName(), CatalogObjectSerializer.class.getCanonicalName()));
                    }
                    List serializers = (List)result.computeIfAbsent(type.id(), v -> new ArrayList());
                    try {
                        CatalogObjectSerializer<? extends MarshallableEntry> serializer = this.instantiate(clazz);
                        if (ann.version() <= 0) {
                            throw new IllegalArgumentException("Serializer `version` attribute must be positive [version=" + ann.version() + ", class=" + clazz.getCanonicalName() + "].");
                        }
                        if (ann.since().isBlank()) {
                            throw new IllegalArgumentException("Serializer 'since' attribute can't be empty or blank [class=" + clazz.getCanonicalName() + "].");
                        }
                        serializers.add(new CatalogVersionAwareSerializer<MarshallableEntry>(serializer, ann.version()));
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                        throw new RuntimeException("Cannot instantiate serializer [class=" + clazz + "].", e);
                    }
                    atLeastSingleSerializerExists = true;
                }
                if (atLeastSingleSerializerExists) continue;
                throw new IllegalStateException("At least one serializer must be implemented [type=" + type + "].");
            }
            return result;
        }

        private CatalogObjectSerializer<? extends MarshallableEntry> instantiate(Class<?> cls) throws InvocationTargetException, InstantiationException, IllegalAccessException {
            Constructor<?>[] constructors;
            for (Constructor<?> constructor : constructors = cls.getDeclaredConstructors()) {
                constructor.setAccessible(true);
                if (constructor.getParameterCount() == 0) {
                    return (CatalogObjectSerializer)constructor.newInstance(new Object[0]);
                }
                if (constructor.getParameterCount() != 1 || !CatalogEntrySerializerProvider.class.isAssignableFrom(constructor.getParameterTypes()[0])) continue;
                return (CatalogObjectSerializer)constructor.newInstance(this.provider);
            }
            throw new IllegalStateException("Unable to create serializer, required constructor was not found [class=" + cls + "].");
        }

        private static Int2ObjectMap<CatalogVersionAwareSerializer<? extends MarshallableEntry>[]> remapToOrderedArray(int baseVersion, Int2ObjectMap<List<CatalogVersionAwareSerializer<? extends MarshallableEntry>>> mapByType) {
            Int2ObjectOpenHashMap result = new Int2ObjectOpenHashMap(mapByType.size());
            for (Int2ObjectMap.Entry entry : mapByType.int2ObjectEntrySet()) {
                List serializers = (List)entry.getValue();
                int typeId = entry.getIntKey();
                CatalogVersionAwareSerializer[] orderedSerializers = new CatalogVersionAwareSerializer[serializers.size()];
                for (CatalogVersionAwareSerializer serializer : serializers) {
                    int versionIdx = serializer.version() - baseVersion;
                    if (versionIdx >= orderedSerializers.length) {
                        throw new IllegalArgumentException(IgniteStringFormatter.format("Serializer version must be incremented by one [typeId={}, version={}, expected={}, class={}].", typeId, serializer.version(), orderedSerializers.length, serializer.delegate().getClass()));
                    }
                    if (orderedSerializers[versionIdx] != null) {
                        throw new IllegalArgumentException(IgniteStringFormatter.format("Duplicate serializer version [serializer1={}, serializer2={}].", orderedSerializers[versionIdx].delegate().getClass().getCanonicalName(), serializer.delegate().getClass().getCanonicalName()));
                    }
                    orderedSerializers[versionIdx] = serializer;
                }
                result.put(typeId, (Object)orderedSerializers);
            }
            return result;
        }
    }
}

