/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.storage;

import java.io.IOException;
import java.util.List;
import org.apache.ignite3.internal.catalog.storage.UpdateEntry;
import org.apache.ignite3.internal.catalog.storage.VersionedUpdate;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectDataInput;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectDataOutput;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogSerializer;

public class VersionedUpdateSerializers {

    @CatalogSerializer(version=2, since="gridgain-9.1.0")
    public static class VersionedUpdateSerializerV2
    implements CatalogObjectSerializer<VersionedUpdate> {
        @Override
        public VersionedUpdate readFrom(CatalogObjectDataInput input) throws IOException {
            int ver = input.readVarIntAsInt();
            long delayDurationMs = input.readVarInt();
            List<UpdateEntry> entries = input.readEntryList(UpdateEntry.class);
            return new VersionedUpdate(ver, delayDurationMs, entries);
        }

        @Override
        public void writeTo(VersionedUpdate value, CatalogObjectDataOutput output) throws IOException {
            output.writeVarInt(value.version());
            output.writeVarInt(value.delayDurationMs());
            output.writeEntryList(value.entries());
        }
    }
}

