/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.storage;

import java.io.IOException;
import org.apache.ignite3.internal.catalog.storage.SetExpireEntry;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectDataInput;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectDataOutput;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogSerializer;

public class SetExpireEntrySerializers {

    @CatalogSerializer(version=2, since="gridgain-9.1.0")
    private static class SetExpireEntrySerializerV2
    implements CatalogObjectSerializer<SetExpireEntry> {
        private SetExpireEntrySerializerV2() {
        }

        @Override
        public SetExpireEntry readFrom(CatalogObjectDataInput input) throws IOException {
            int tableId = input.readVarIntAsInt();
            String expireColumn = input.readUTF();
            int expireColumnId = input.readVarIntAsInt();
            return new SetExpireEntry(tableId, expireColumn, expireColumnId);
        }

        @Override
        public void writeTo(SetExpireEntry entry, CatalogObjectDataOutput output) throws IOException {
            output.writeVarInt(entry.tableId);
            output.writeUTF(entry.expireColumn);
            output.writeVarInt(entry.expireColumnIndexId.intValue());
        }
    }
}

