/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.storage;

import java.io.IOException;
import org.apache.ignite3.internal.catalog.storage.AddSecondaryZoneEntry;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectDataInput;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectDataOutput;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogSerializer;

public class AddSecondaryZoneEntrySerializers {

    @CatalogSerializer(version=2, since="gridgain-9.1.3")
    static class AddSecondaryZoneEntrySerializerV2
    implements CatalogObjectSerializer<AddSecondaryZoneEntry> {
        AddSecondaryZoneEntrySerializerV2() {
        }

        @Override
        public AddSecondaryZoneEntry readFrom(CatalogObjectDataInput input) throws IOException {
            int tableId = input.readVarIntAsInt();
            int secondaryZoneId = input.readVarIntAsInt();
            String secondaryStorageProfile = input.readUTF();
            return new AddSecondaryZoneEntry(tableId, secondaryZoneId, secondaryStorageProfile);
        }

        @Override
        public void writeTo(AddSecondaryZoneEntry value, CatalogObjectDataOutput output) throws IOException {
            output.writeVarInt(value.tableId());
            output.writeVarInt(value.secondaryZoneId());
            output.writeUTF(value.secondaryStorageProfile());
        }
    }
}

