/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.sql;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.catalog.ColumnSorted;
import org.apache.ignite3.catalog.IndexType;
import org.apache.ignite3.catalog.definitions.CacheDefinition;
import org.apache.ignite3.catalog.definitions.ColumnDefinition;
import org.apache.ignite3.internal.catalog.sql.DefinitionCollector;
import org.apache.ignite3.sql.IgniteSql;
import org.apache.ignite3.table.QualifiedName;

class CacheDefinitionCollector {
    private final DefinitionCollector<CacheDefinition> collector;

    CacheDefinitionCollector(QualifiedName tableName, IgniteSql sql) {
        this.collector = new DefinitionCollector<CacheDefinition>(tableName, sql, new CollectorCacheDefinitionBuilder(), "IS TRUE");
    }

    CompletableFuture<CacheDefinition> collectDefinition() {
        return this.collector.collectDefinition();
    }

    private static class CollectorCacheDefinitionBuilder
    implements DefinitionCollector.DefinitionBuilder<CacheDefinition> {
        private CacheDefinition.Builder builder;

        private CollectorCacheDefinitionBuilder() {
        }

        @Override
        public DefinitionCollector.DefinitionBuilder<CacheDefinition> newBuilder(QualifiedName objectName) {
            this.builder = CacheDefinition.builder(objectName);
            return this;
        }

        @Override
        public DefinitionCollector.DefinitionBuilder<CacheDefinition> zone(String zone) {
            this.builder.zone(zone);
            return this;
        }

        @Override
        public DefinitionCollector.DefinitionBuilder<CacheDefinition> primaryKey(IndexType type, List<ColumnSorted> columns) {
            this.builder.primaryKey(type, columns);
            return this;
        }

        @Override
        public DefinitionCollector.DefinitionBuilder<CacheDefinition> index(String name, IndexType type, List<ColumnSorted> columns) {
            this.builder.index(name, type, columns);
            return this;
        }

        @Override
        public DefinitionCollector.DefinitionBuilder<CacheDefinition> colocateBy(List<String> colocationColumn) {
            this.builder.colocateBy(colocationColumn);
            return this;
        }

        @Override
        public DefinitionCollector.DefinitionBuilder<CacheDefinition> columns(List<ColumnDefinition> columns) {
            this.builder.columns(columns);
            return this;
        }

        @Override
        public CacheDefinition build() {
            return this.builder.build();
        }
    }
}

