/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.descriptors;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableColumnDescriptor;
import org.apache.ignite3.internal.catalog.storage.serialization.MarshallableEntry;
import org.apache.ignite3.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite3.internal.util.ArrayUtils;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;

public class CatalogTableSchemaVersions
implements MarshallableEntry {
    private final int base;
    private final int nextColumnId;
    private final TableVersion[] versions;

    public CatalogTableSchemaVersions(TableVersion version) {
        this(1, version.columns.size(), version.assignColumnIds(new IdGenerator(0), (Object2IntMap<String>)new Object2IntOpenHashMap()));
    }

    CatalogTableSchemaVersions(int base, int nextColumnId, TableVersion ... versions) {
        CatalogTableSchemaVersions.validateColumnIdsAreAssigned(nextColumnId, versions);
        this.base = base;
        this.nextColumnId = nextColumnId;
        this.versions = versions;
    }

    int nextColumnId() {
        return this.nextColumnId;
    }

    public int earliestVersion() {
        return this.base;
    }

    public int latestVersion() {
        return this.base + this.versions.length - 1;
    }

    public List<CatalogTableColumnDescriptor> latestVersionColumns() {
        return this.versions[this.versions.length - 1].columns();
    }

    TableVersion[] versions() {
        return this.versions;
    }

    @Nullable
    public TableVersion get(int version) {
        if (version < this.base || version >= this.base + this.versions.length) {
            return null;
        }
        return this.versions[version - this.base];
    }

    public CatalogTableSchemaVersions append(TableVersion tableVersion) {
        TableVersion latestVersion = this.versions[this.versions.length - 1];
        Object2IntOpenHashMap knownColumns = new Object2IntOpenHashMap();
        for (CatalogTableColumnDescriptor column : latestVersion.columns) {
            assert (column.id() != -1) : "latest existing TableVersion contains column with unassigned id";
            knownColumns.put((Object)column.name(), column.id());
        }
        IdGenerator idGenerator = new IdGenerator(this.nextColumnId);
        tableVersion = tableVersion.assignColumnIds(idGenerator, (Object2IntMap<String>)knownColumns);
        return new CatalogTableSchemaVersions(this.base, idGenerator.nextId, ArrayUtils.concat(this.versions, tableVersion));
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.DESCRIPTOR_TABLE_SCHEMA_VERSIONS.id();
    }

    static TableVersion[] assignColumnIds(IdGenerator idGenerator, TableVersion[] versions) {
        Object2IntOpenHashMap knownColumns = new Object2IntOpenHashMap();
        TableVersion[] newVersions = new TableVersion[versions.length];
        for (int i = 0; i < versions.length; ++i) {
            newVersions[i] = versions[i].assignColumnIds(idGenerator, (Object2IntMap<String>)knownColumns);
        }
        return newVersions;
    }

    private static void validateColumnIdsAreAssigned(int nextColumnId, TableVersion[] versions) {
        if (!IgniteUtils.assertionsEnabled()) {
            return;
        }
        for (TableVersion version : versions) {
            int lastSeenColumnId = -1;
            for (CatalogTableColumnDescriptor column : version.columns) {
                assert (column.id() != -1) : "One or more column doesn't have an id assigned";
                assert (column.id() > lastSeenColumnId) : "Column ids must be increasing: " + version.columns;
                assert (column.id() < nextColumnId) : "Column ids of existing columns must be less than nextColumnId: " + version.columns;
                lastSeenColumnId = column.id();
            }
        }
    }

    public static class TableVersion
    implements MarshallableEntry {
        private final List<CatalogTableColumnDescriptor> columns;

        public TableVersion(List<CatalogTableColumnDescriptor> columns) {
            this.columns = columns;
        }

        public List<CatalogTableColumnDescriptor> columns() {
            return Collections.unmodifiableList(this.columns);
        }

        @Override
        public int typeId() {
            return MarshallableEntryType.DESCRIPTOR_TABLE_VERSION.id();
        }

        private TableVersion assignColumnIds(IdGenerator idGenerator, Object2IntMap<String> knownColumns) {
            if (this.columns.isEmpty()) {
                return this;
            }
            ArrayList<CatalogTableColumnDescriptor> newColumns = new ArrayList<CatalogTableColumnDescriptor>(this.columns.size());
            HashSet<String> columnsExistingInCurrentVersion = IgniteUtils.newHashSet(this.columns.size());
            for (CatalogTableColumnDescriptor column : this.columns) {
                columnsExistingInCurrentVersion.add(column.name());
                int newId = knownColumns.computeIfAbsent((Object)column.name(), k -> idGenerator.nextId());
                newColumns.add(column.clone(newId));
            }
            knownColumns.keySet().removeIf(name -> !columnsExistingInCurrentVersion.contains(name));
            return new TableVersion(newColumns);
        }
    }

    static class IdGenerator {
        private int nextId;

        IdGenerator(int initialId) {
            this.nextId = initialId;
        }

        int nextId() {
            return this.nextId++;
        }
    }
}

