/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.descriptors;

import java.util.Arrays;
import java.util.Objects;
import org.apache.ignite3.internal.tostring.S;

public abstract class CatalogTablePolicyPredicate {
    public abstract TablePolicyPredicateType type();

    public static final class TablePolicyPredicateType
    extends Enum<TablePolicyPredicateType> {
        public static final /* enum */ TablePolicyPredicateType CURRENT_USER = new TablePolicyPredicateType(1);
        public static final /* enum */ TablePolicyPredicateType ALWAYS_TRUE = new TablePolicyPredicateType(2);
        private final int id;
        private static final TablePolicyPredicateType[] VALS;
        private static final /* synthetic */ TablePolicyPredicateType[] $VALUES;

        public static TablePolicyPredicateType[] values() {
            return (TablePolicyPredicateType[])$VALUES.clone();
        }

        public static TablePolicyPredicateType valueOf(String name) {
            return Enum.valueOf(TablePolicyPredicateType.class, name);
        }

        private TablePolicyPredicateType(int id) {
            this.id = id;
        }

        int id() {
            return this.id;
        }

        static TablePolicyPredicateType getById(int id) {
            TablePolicyPredicateType predicateType;
            TablePolicyPredicateType tablePolicyPredicateType = predicateType = id >= 0 && id < VALS.length ? VALS[id] : null;
            if (predicateType == null) {
                throw new IllegalArgumentException("Predicate doesn't exists [id=" + id + "]");
            }
            return predicateType;
        }

        private static /* synthetic */ TablePolicyPredicateType[] $values() {
            return new TablePolicyPredicateType[]{CURRENT_USER, ALWAYS_TRUE};
        }

        static {
            $VALUES = TablePolicyPredicateType.$values();
            int maxId = Arrays.stream(TablePolicyPredicateType.values()).mapToInt(TablePolicyPredicateType::id).max().orElse(0);
            TablePolicyPredicateType[] vals = new TablePolicyPredicateType[maxId + 1];
            for (TablePolicyPredicateType predicateType : TablePolicyPredicateType.values()) {
                TablePolicyPredicateType existing = vals[predicateType.id];
                assert (existing == null) : "Found duplicate id " + predicateType.id;
                vals[predicateType.id] = predicateType;
            }
            VALS = vals;
        }
    }

    public static class AlwaysTruePolicyPredicate
    extends CatalogTablePolicyPredicate {
        @Override
        public TablePolicyPredicateType type() {
            return TablePolicyPredicateType.ALWAYS_TRUE;
        }

        public String toString() {
            return S.toString(AlwaysTruePolicyPredicate.class, this);
        }
    }

    public static class CurrentUserPolicyPredicate
    extends CatalogTablePolicyPredicate {
        private final String columnName;

        public CurrentUserPolicyPredicate(String columnName) {
            Objects.requireNonNull(columnName, "columnName");
            this.columnName = columnName;
        }

        @Override
        public TablePolicyPredicateType type() {
            return TablePolicyPredicateType.CURRENT_USER;
        }

        public String columnName() {
            return this.columnName;
        }

        public String toString() {
            return S.toString(CurrentUserPolicyPredicate.class, this);
        }
    }
}

