/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.descriptors;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogMapDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogObjectDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSequenceDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogStatisticsDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSystemViewDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTablePolicyDescriptor;
import org.apache.ignite3.internal.catalog.storage.serialization.MarshallableEntry;
import org.apache.ignite3.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.tostring.IgniteToStringExclude;
import org.apache.ignite3.internal.tostring.S;
import org.jetbrains.annotations.Nullable;

public class CatalogSchemaDescriptor
extends CatalogObjectDescriptor
implements MarshallableEntry {
    private final CatalogTableDescriptor[] tables;
    private final CatalogIndexDescriptor[] indexes;
    private final CatalogSequenceDescriptor[] sequences;
    private final CatalogSystemViewDescriptor[] systemViews;
    private final CatalogTablePolicyDescriptor[] policies;
    private final CatalogMapDescriptor[] maps;
    private final CatalogStatisticsDescriptor[] statistics;
    @IgniteToStringExclude
    private Map<String, CatalogTableDescriptor> tablesMap;
    @IgniteToStringExclude
    private Map<String, CatalogIndexDescriptor> indexesMap;
    @IgniteToStringExclude
    private Map<String, CatalogSystemViewDescriptor> systemViewsMap;
    @IgniteToStringExclude
    private Map<String, CatalogSequenceDescriptor> sequencesMap;
    @IgniteToStringExclude
    private Map<String, CatalogTablePolicyDescriptor> policiesMap;
    @IgniteToStringExclude
    private Map<String, CatalogMapDescriptor> mapsMap;
    @IgniteToStringExclude
    private Map<String, CatalogStatisticsDescriptor> statisticsMap;

    public CatalogSchemaDescriptor(int id, String name, CatalogTableDescriptor[] tables, CatalogIndexDescriptor[] indexes, CatalogSystemViewDescriptor[] systemViews, CatalogSequenceDescriptor[] sequences, CatalogTablePolicyDescriptor[] policies, CatalogMapDescriptor[] maps, CatalogStatisticsDescriptor[] statistics, HybridTimestamp timestamp) {
        super(id, CatalogObjectDescriptor.Type.SCHEMA, name, timestamp);
        this.tables = Objects.requireNonNull(tables, "tables");
        this.indexes = Objects.requireNonNull(indexes, "indexes");
        this.sequences = Objects.requireNonNull(sequences, "sequences");
        this.systemViews = Objects.requireNonNull(systemViews, "systemViews");
        this.policies = Objects.requireNonNull(policies, "policies");
        this.maps = Objects.requireNonNull(maps, "maps");
        this.statistics = Objects.requireNonNull(statistics, "statistics");
        this.rebuildMaps();
    }

    @Deprecated
    public CatalogSchemaDescriptor(int id, String name, CatalogTableDescriptor[] tables, CatalogIndexDescriptor[] indexes, CatalogSystemViewDescriptor[] systemViews, CatalogSequenceDescriptor[] sequences, CatalogTablePolicyDescriptor[] policies, HybridTimestamp timestamp) {
        this(id, name, tables, indexes, systemViews, sequences, policies, new CatalogMapDescriptor[0], new CatalogStatisticsDescriptor[0], timestamp);
    }

    @Deprecated
    public CatalogSchemaDescriptor(int id, String name, CatalogTableDescriptor[] tables, CatalogIndexDescriptor[] indexes, CatalogSystemViewDescriptor[] systemViews, CatalogSequenceDescriptor[] sequences, HybridTimestamp timestamp) {
        this(id, name, tables, indexes, systemViews, sequences, new CatalogTablePolicyDescriptor[0], timestamp);
    }

    public CatalogTableDescriptor[] tables() {
        return this.tables;
    }

    public CatalogIndexDescriptor[] indexes() {
        return this.indexes;
    }

    public CatalogSystemViewDescriptor[] systemViews() {
        return this.systemViews;
    }

    public CatalogSequenceDescriptor[] sequences() {
        return this.sequences;
    }

    public CatalogTablePolicyDescriptor[] policies() {
        return this.policies;
    }

    public CatalogMapDescriptor[] maps() {
        return this.maps;
    }

    public CatalogStatisticsDescriptor[] statistics() {
        return this.statistics;
    }

    @Nullable
    public CatalogStatisticsDescriptor statistics(String name) {
        return this.statisticsMap.get(name);
    }

    @Nullable
    public CatalogTableDescriptor table(String name) {
        return this.tablesMap.get(name);
    }

    @Nullable
    public CatalogSequenceDescriptor sequence(String name) {
        return this.sequencesMap.get(name);
    }

    @Nullable
    public CatalogIndexDescriptor aliveIndex(String name) {
        return this.indexesMap.get(name);
    }

    @Nullable
    public CatalogSystemViewDescriptor systemView(String name) {
        return this.systemViewsMap.get(name);
    }

    @Nullable
    public CatalogTablePolicyDescriptor policy(String name) {
        return this.policiesMap.get(name);
    }

    @Nullable
    public CatalogMapDescriptor map(String name) {
        return this.mapsMap.get(name);
    }

    public boolean isEmpty() {
        return this.tables.length == 0 && this.indexes.length == 0 && this.systemViews.length == 0 && this.policies.length == 0 && this.sequences.length == 0;
    }

    private void rebuildMaps() {
        this.tablesMap = Arrays.stream(this.tables).collect(Collectors.toUnmodifiableMap(CatalogObjectDescriptor::name, Function.identity()));
        this.indexesMap = Arrays.stream(this.indexes).filter(index -> index.status().isAlive()).collect(Collectors.toUnmodifiableMap(CatalogObjectDescriptor::name, Function.identity()));
        this.sequencesMap = Arrays.stream(this.sequences).collect(Collectors.toUnmodifiableMap(CatalogObjectDescriptor::name, Function.identity()));
        this.systemViewsMap = Arrays.stream(this.systemViews).collect(Collectors.toUnmodifiableMap(CatalogObjectDescriptor::name, Function.identity()));
        this.policiesMap = Arrays.stream(this.policies).collect(Collectors.toUnmodifiableMap(CatalogObjectDescriptor::name, Function.identity()));
        this.mapsMap = Arrays.stream(this.maps).collect(Collectors.toUnmodifiableMap(CatalogObjectDescriptor::name, Function.identity()));
        this.statisticsMap = Arrays.stream(this.statistics).collect(Collectors.toUnmodifiableMap(CatalogObjectDescriptor::name, Function.identity()));
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.DESCRIPTOR_SCHEMA.id();
    }

    @Override
    public String toString() {
        return S.toString(CatalogSchemaDescriptor.class, this, super.toString());
    }
}

