/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.compaction.message;

import java.util.BitSet;
import org.apache.ignite3.internal.catalog.compaction.message.AvailablePartitionsMessage;
import org.apache.ignite3.internal.catalog.compaction.message.AvailablePartitionsMessageBuilder;
import org.apache.ignite3.internal.catalog.compaction.message.CatalogCompactionMessagesFactory;
import org.apache.ignite3.internal.catalog.compaction.message.CatalogCompactionMessagesTypeInfos;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;

class AvailablePartitionsMessageDeserializer
implements MessageDeserializer<AvailablePartitionsMessage> {
    private final AvailablePartitionsMessageBuilder msg;

    AvailablePartitionsMessageDeserializer(CatalogCompactionMessagesFactory messageFactory) {
        this.msg = messageFactory.availablePartitionsMessage();
    }

    @Override
    public Class<AvailablePartitionsMessage> klass() {
        return AvailablePartitionsMessage.class;
    }

    @Override
    public AvailablePartitionsMessage getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(CatalogCompactionMessagesTypeInfos.availablePartitionsMessage());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                BitSet tmp = reader.readBitSet("partitions");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.partitions(tmp);
                }
                reader.incrementState();
            }
            case 1: {
                int tmp = reader.readInt("tableId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.tableId(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(AvailablePartitionsMessage.class);
    }
}

