/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.commands;

import java.util.Collections;
import java.util.List;
import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.CatalogCommand;
import org.apache.ignite3.internal.catalog.CatalogParamsValidationUtils;
import org.apache.ignite3.internal.catalog.UpdateContext;
import org.apache.ignite3.internal.catalog.commands.CatalogUtils;
import org.apache.ignite3.internal.catalog.commands.SecondaryStorageAvailableCommandBuilder;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSecondaryStorageState;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite3.internal.catalog.storage.SecondaryStorageAvailableEntry;
import org.apache.ignite3.internal.catalog.storage.UpdateEntry;

public class SecondaryStorageAvailableCommand
implements CatalogCommand {
    private final String schemaName;
    private final String tableName;

    private SecondaryStorageAvailableCommand(String schemaName, String tableName) {
        this.schemaName = schemaName;
        this.tableName = tableName;
    }

    @Override
    public List<UpdateEntry> get(UpdateContext updateContext) {
        Catalog catalog = updateContext.catalog();
        CatalogSchemaDescriptor schema = CatalogUtils.schema(catalog, this.schemaName, false);
        if (schema == null) {
            return Collections.emptyList();
        }
        CatalogTableDescriptor table = CatalogUtils.table(schema, this.tableName, false);
        if (table == null || table.secondaryStorageState() != CatalogSecondaryStorageState.SYNCING) {
            return Collections.emptyList();
        }
        return List.of(new SecondaryStorageAvailableEntry(table.id()));
    }

    public static SecondaryStorageAvailableCommandBuilder builder() {
        return new Builder();
    }

    private static final class Builder
    implements SecondaryStorageAvailableCommandBuilder {
        private String schemaName;
        private String tableName;

        private Builder() {
        }

        @Override
        public SecondaryStorageAvailableCommandBuilder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        @Override
        public SecondaryStorageAvailableCommandBuilder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        @Override
        public CatalogCommand build() {
            CatalogParamsValidationUtils.validateIdentifier(this.schemaName, "Name of the schema");
            CatalogParamsValidationUtils.validateIdentifier(this.tableName, "Name of the table");
            return new SecondaryStorageAvailableCommand(this.schemaName, this.tableName);
        }
    }
}

