/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.commands;

import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.commands.DefaultValue;
import org.apache.ignite3.sql.ColumnType;
import org.jetbrains.annotations.Nullable;

public abstract class DeferredDefaultValue {
    public abstract DefaultValue derive(Catalog var1, ColumnType var2);

    public abstract DefaultValue.Type type();

    public static DeferredDefaultValue from(DefaultValue defaultValue) {
        Objects.requireNonNull(defaultValue, "defaultValue");
        if (defaultValue instanceof DefaultValue.ConstantValue) {
            DefaultValue.ConstantValue constantValue = (DefaultValue.ConstantValue)defaultValue;
            return new Constant(constantValue.value(), null);
        }
        if (defaultValue instanceof DefaultValue.FunctionCall) {
            DefaultValue.FunctionCall functionCall = (DefaultValue.FunctionCall)defaultValue;
            return new FunctionCall(functionCall.functionName(), functionCall.parameters(), functionCall.computedValue(), null);
        }
        throw new IllegalArgumentException("Unexpected default type: " + defaultValue);
    }

    public static DeferredDefaultValue constantValue(@Nullable Object value) {
        return new Constant(value, null);
    }

    public static DeferredDefaultValue constant(Function<ColumnType, DefaultValue> resolve) {
        Objects.requireNonNull(resolve, "revolve");
        return new Constant(null, resolve);
    }

    public static DeferredDefaultValue functionCall(String functionName) {
        return new FunctionCall(functionName, List.of(), null, null);
    }

    public static DeferredDefaultValue functionCall(String functionName, List<Object> parameters, @Nullable Object computedValue, @Nullable FunctionParametersResolver resolver) {
        return new FunctionCall(functionName, parameters, computedValue, resolver);
    }

    public static class Constant
    extends DeferredDefaultValue {
        @Nullable
        private final Object value;
        private final Function<ColumnType, DefaultValue> resolve;

        Constant(@Nullable Object value, Function<ColumnType, DefaultValue> resolve) {
            this.value = value;
            this.resolve = resolve;
        }

        @Override
        public DefaultValue derive(Catalog catalog, ColumnType type) {
            if (this.resolve != null) {
                DefaultValue resolved = this.resolve.apply(type);
                assert (resolved != null) : "resolved to null";
                assert (resolved.type() == DefaultValue.Type.CONSTANT) : "Resolved a constant default into a non-constant " + resolved;
                return resolved;
            }
            return DefaultValue.constant(this.value);
        }

        @Override
        public DefaultValue.Type type() {
            return DefaultValue.Type.CONSTANT;
        }
    }

    public static class FunctionCall
    extends DeferredDefaultValue {
        private final String name;
        private final List<Object> parameters;
        private final Object computedValue;
        private final FunctionParametersResolver resolver;

        FunctionCall(String name, List<Object> parameters, @Nullable Object computedValue, @Nullable FunctionParametersResolver resolver) {
            this.name = name;
            this.parameters = parameters;
            this.computedValue = computedValue;
            this.resolver = resolver;
        }

        public String functionName() {
            return this.name;
        }

        public List<Object> parameters() {
            return this.parameters;
        }

        @Override
        public DefaultValue derive(Catalog catalog, ColumnType type) {
            DefaultValue initial = DefaultValue.functionCall(this.name, this.parameters, this.computedValue);
            if (this.resolver == null) {
                return initial;
            }
            List<Object> resolved = this.resolver.resolve(catalog, type, this.parameters);
            Objects.requireNonNull(resolved, "resolved parameters must not be null");
            return DefaultValue.functionCall(this.name, resolved, this.computedValue);
        }

        @Override
        public DefaultValue.Type type() {
            return DefaultValue.Type.FUNCTION_CALL;
        }
    }

    @FunctionalInterface
    public static interface FunctionParametersResolver {
        public List<Object> resolve(Catalog var1, ColumnType var2, List<Object> var3);
    }
}

