/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.commands;

import java.util.List;
import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.CatalogCommand;
import org.apache.ignite3.internal.catalog.CatalogValidationException;
import org.apache.ignite3.internal.catalog.UpdateContext;
import org.apache.ignite3.internal.catalog.commands.AbstractTableCommand;
import org.apache.ignite3.internal.catalog.commands.AlterTableDropExpireCommandBuilder;
import org.apache.ignite3.internal.catalog.commands.CatalogUtils;
import org.apache.ignite3.internal.catalog.commands.DropIndexCommand;
import org.apache.ignite3.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite3.internal.catalog.storage.DropExpireEntry;
import org.apache.ignite3.internal.catalog.storage.UpdateEntry;
import org.apache.ignite3.internal.lang.IgniteStringFormatter;

public class AlterTableDropExpireCommand
extends AbstractTableCommand {
    public static AlterTableDropExpireCommandBuilder builder() {
        return new Builder();
    }

    private AlterTableDropExpireCommand(String schemaName, String tableName, boolean ifTableExists) throws CatalogValidationException {
        super(schemaName, tableName, ifTableExists, true);
    }

    @Override
    public List<UpdateEntry> get(UpdateContext updateContext) {
        Catalog catalog = updateContext.catalog();
        CatalogSchemaDescriptor schema = CatalogUtils.schema(catalog, this.schemaName, !this.ifTableExists);
        if (schema == null) {
            return List.of();
        }
        CatalogTableDescriptor table = CatalogUtils.table(schema, this.tableName, !this.ifTableExists);
        if (table == null) {
            return List.of();
        }
        if (table.expireColumn() == null) {
            throw new CatalogValidationException(IgniteStringFormatter.format("Expire column is not set on the table '{}.{}'.", this.schemaName, this.tableName));
        }
        Integer expireColumnIndexId = table.expireColumnIndexId();
        assert (expireColumnIndexId != null);
        CatalogIndexDescriptor index = CatalogUtils.indexOrThrow(catalog, expireColumnIndexId);
        return List.of(new DropExpireEntry(table.id()), DropIndexCommand.updateEntryForIndex(index));
    }

    private static class Builder
    implements AlterTableDropExpireCommandBuilder {
        private String schemaName;
        private String tableName;
        private boolean ifTableExists;

        private Builder() {
        }

        @Override
        public AlterTableDropExpireCommandBuilder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        @Override
        public AlterTableDropExpireCommandBuilder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        @Override
        public AlterTableDropExpireCommandBuilder ifTableExists(boolean ifTableExists) {
            this.ifTableExists = ifTableExists;
            return this;
        }

        @Override
        public CatalogCommand build() {
            return new AlterTableDropExpireCommand(this.schemaName, this.tableName, this.ifTableExists);
        }
    }
}

