/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.commands;

import java.util.List;
import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.CatalogCommand;
import org.apache.ignite3.internal.catalog.CatalogValidationException;
import org.apache.ignite3.internal.catalog.UpdateContext;
import org.apache.ignite3.internal.catalog.commands.AbstractCacheCommand;
import org.apache.ignite3.internal.catalog.commands.AlterCacheDropExpireCommandBuilder;
import org.apache.ignite3.internal.catalog.commands.CatalogUtils;
import org.apache.ignite3.internal.catalog.commands.DropIndexCommand;
import org.apache.ignite3.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite3.internal.catalog.storage.DropExpireEntry;
import org.apache.ignite3.internal.catalog.storage.UpdateEntry;
import org.apache.ignite3.internal.lang.IgniteStringFormatter;

public class AlterCacheDropExpireCommand
extends AbstractCacheCommand {
    public static AlterCacheDropExpireCommandBuilder builder() {
        return new Builder();
    }

    private AlterCacheDropExpireCommand(String schemaName, String cacheName, boolean ifTableExists) throws CatalogValidationException {
        super(schemaName, cacheName, ifTableExists);
    }

    @Override
    public List<UpdateEntry> get(UpdateContext updateContext) {
        Catalog catalog = updateContext.catalog();
        CatalogSchemaDescriptor schema = CatalogUtils.schema(catalog, this.schemaName, !this.ifTableExists);
        if (schema == null) {
            return List.of();
        }
        CatalogTableDescriptor cache = CatalogUtils.cache(schema, this.cacheName, !this.ifTableExists);
        if (cache == null) {
            return List.of();
        }
        if (cache.expireColumn() == null) {
            throw new CatalogValidationException(IgniteStringFormatter.format("Expire column is not set on the cache '{}.{}'.", this.schemaName, this.cacheName));
        }
        Integer expireColumnIndexId = cache.expireColumnIndexId();
        assert (expireColumnIndexId != null);
        CatalogIndexDescriptor index = CatalogUtils.indexOrThrow(catalog, expireColumnIndexId);
        return List.of(new DropExpireEntry(cache.id()), DropIndexCommand.updateEntryForIndex(index));
    }

    private static class Builder
    implements AlterCacheDropExpireCommandBuilder {
        private String schemaName;
        private String cacheName;
        private boolean ifTableExists;

        private Builder() {
        }

        @Override
        public AlterCacheDropExpireCommandBuilder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        @Override
        public AlterCacheDropExpireCommandBuilder cacheName(String cacheName) {
            this.cacheName = cacheName;
            return this;
        }

        @Override
        public AlterCacheDropExpireCommandBuilder ifCacheExists(boolean ifTableExists) {
            this.ifTableExists = ifTableExists;
            return this;
        }

        @Override
        public CatalogCommand build() {
            return new AlterCacheDropExpireCommand(this.schemaName, this.cacheName, this.ifTableExists);
        }
    }
}

