/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.client.handler.requests.tx;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.client.handler.ClientHandlerMetricSource;
import org.apache.ignite3.client.handler.ClientResource;
import org.apache.ignite3.client.handler.ClientResourceRegistry;
import org.apache.ignite3.client.handler.ResponseWriter;
import org.apache.ignite3.client.handler.requests.table.ClientTableCommon;
import org.apache.ignite3.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.hlc.HybridTimestampTracker;
import org.apache.ignite3.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite3.internal.tx.InternalTransaction;
import org.apache.ignite3.internal.tx.InternalTxOptions;
import org.apache.ignite3.internal.tx.TxManager;
import org.gridgain.internal.license.LicenseFeatureChecker;

public class ClientTransactionBeginRequest {
    public static CompletableFuture<ResponseWriter> process(ClientMessageUnpacker in, TxManager txManager, ClientResourceRegistry resources, ClientHandlerMetricSource metrics, HybridTimestampTracker tsTracker, LicenseFeatureChecker licenseFeatureChecker, boolean external) throws IgniteInternalCheckedException {
        boolean readOnly = in.unpackBoolean();
        long timeoutMillis = in.unpackLong();
        HybridTimestamp observableTs = null;
        if (readOnly) {
            observableTs = HybridTimestamp.nullableHybridTimestamp(in.unpackLong());
        }
        InternalTxOptions txOptions = InternalTxOptions.builder().timeoutMillis(timeoutMillis).build();
        InternalTransaction tx = ClientTableCommon.startExplicitTx(tsTracker, txManager, licenseFeatureChecker, observableTs, readOnly, txOptions, external);
        if (readOnly) {
            tsTracker.update(tx.readTimestamp());
        }
        try {
            long resourceId = resources.put(new ClientResource(tx, tx::rollbackAsync));
            metrics.transactionsActiveIncrement();
            return CompletableFuture.completedFuture(out -> out.packLong(resourceId));
        }
        catch (IgniteInternalCheckedException e) {
            tx.rollback();
            throw e;
        }
    }
}

