/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.client.handler.requests.table;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.client.handler.ResponseWriter;
import org.apache.ignite3.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite3.internal.table.IgniteTablesInternal;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.lang.IgniteException;
import org.apache.ignite3.lang.util.IgniteNameUtils;
import org.apache.ignite3.table.QualifiedName;

public class ClientTableGetRequest {
    public static CompletableFuture<ResponseWriter> process(ClientMessageUnpacker in, IgniteTablesInternal tables) {
        QualifiedName qualifiedName;
        String tableName = in.unpackString();
        try {
            qualifiedName = QualifiedName.parse(tableName);
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(new IgniteException(ErrorGroups.Common.INTERNAL_ERR, "Unable to parse qualified name", (Throwable)e));
        }
        return tables.tableViewAsync(qualifiedName).thenApply(table -> out -> {
            if (table == null || table.cache()) {
                out.packNil();
            } else {
                out.packInt(table.tableId());
                out.packString(ClientTableGetRequest.quoteTableNameIfNotAllUpper(table.qualifiedName().objectName()));
            }
        });
    }

    private static String quoteTableNameIfNotAllUpper(String name) {
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (i > 0 && (Character.isDigit(ch) || ch == '_') || Character.isUpperCase(ch)) continue;
            return IgniteNameUtils.quoteIfNeeded(name);
        }
        return name;
    }
}

