/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.client.handler.requests.sql;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.apache.ignite3.client.handler.ClientHandlerMetricSource;
import org.apache.ignite3.client.handler.ClientResourceRegistry;
import org.apache.ignite3.client.handler.NotificationSender;
import org.apache.ignite3.client.handler.ResponseWriter;
import org.apache.ignite3.client.handler.requests.sql.ClientSqlCommon;
import org.apache.ignite3.client.handler.requests.sql.ClientSqlProperties;
import org.apache.ignite3.client.handler.requests.table.ClientTableCommon;
import org.apache.ignite3.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite3.internal.hlc.ClockService;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.hlc.HybridTimestampTracker;
import org.apache.ignite3.internal.lang.SqlExceptionMapperUtil;
import org.apache.ignite3.internal.sql.api.AsyncResultSetImpl;
import org.apache.ignite3.internal.sql.engine.AsyncSqlCursor;
import org.apache.ignite3.internal.sql.engine.InternalSqlRow;
import org.apache.ignite3.internal.sql.engine.QueryProcessor;
import org.apache.ignite3.internal.sql.engine.SqlProperties;
import org.apache.ignite3.internal.tx.InternalTransaction;
import org.apache.ignite3.internal.tx.TxManager;
import org.apache.ignite3.internal.util.ArrayUtils;
import org.apache.ignite3.internal.util.AsyncCursor;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.util.ExceptionUtils;
import org.apache.ignite3.lang.CancelHandle;
import org.apache.ignite3.lang.CancellationToken;
import org.apache.ignite3.sql.SqlRow;
import org.apache.ignite3.table.IgniteTables;
import org.apache.ignite3.tx.Transaction;
import org.gridgain.internal.license.LicenseFeatureChecker;
import org.gridgain.internal.security.context.GridGainSecurity;
import org.gridgain.internal.security.context.SecurityContext;
import org.gridgain.internal.security.context.SecurityContextHolder;
import org.jetbrains.annotations.Nullable;

public class ClientSqlExecuteRequest {
    public static CompletableFuture<ResponseWriter> process(Executor operationExecutor, ClientMessageUnpacker in, long requestId, Map<Long, CancelHandle> cancelHandles, QueryProcessor sql, ClientResourceRegistry resources, ClientHandlerMetricSource metrics, HybridTimestampTracker timestampTracker, boolean sqlPartitionAwarenessSupported, boolean sqlDirectTxMappingSupported, TxManager txManager, IgniteTables tables, ClockService clockService, LicenseFeatureChecker licenseFeatureChecker, NotificationSender notificationSender, @Nullable String username, boolean sqlMultistatementsSupported) {
        CancelHandle cancelHandle = CancelHandle.create();
        cancelHandles.put(requestId, cancelHandle);
        SecurityContext context = SecurityContextHolder.getOrThrow();
        if (sqlDirectTxMappingSupported && !in.unpackBoolean()) {
            notificationSender = null;
        }
        long[] resIdHolder = new long[]{0L};
        CompletableFuture<InternalTransaction> txFut = ClientTableCommon.readTx(in, timestampTracker, resources, txManager, tables, notificationSender, licenseFeatureChecker, resIdHolder);
        ClientSqlProperties props = new ClientSqlProperties(in, sqlMultistatementsSupported);
        String statement = in.unpackString();
        Object[] arguments = ClientSqlExecuteRequest.readArgsNotNull(in);
        HybridTimestamp clientTs = HybridTimestamp.nullableHybridTimestamp(in.unpackLong());
        timestampTracker.update(clientTs);
        boolean includePartitionAwarenessMeta = sqlPartitionAwarenessSupported && in.unpackBoolean();
        Function<InternalTransaction, CompletableFuture> responseWriterFunction = tx -> ((CompletableFuture)ClientSqlExecuteRequest.executeAsync(tx, sql, timestampTracker, statement, cancelHandle.token(), props.pageSize(), props.toSqlProps().userName(username), () -> cancelHandles.remove(requestId), arguments).thenCompose(asyncResultSet -> ClientSqlCommon.writeResultSetAsync(resources, asyncResultSet, metrics, props.pageSize(), includePartitionAwarenessMeta, sqlDirectTxMappingSupported, sqlMultistatementsSupported, operationExecutor))).thenApply(rsWriter -> out -> {
            if (tx != null) {
                ClientTableCommon.writeTxMeta(out, timestampTracker, clockService, tx, resIdHolder[0]);
            }
            rsWriter.write(out);
        });
        return txFut.thenComposeAsync(GridGainSecurity.with(context, responseWriterFunction), operationExecutor);
    }

    static Object[] readArgsNotNull(ClientMessageUnpacker in) {
        Object[] arguments = in.unpackObjectArrayFromBinaryTuple();
        return arguments == null ? ArrayUtils.OBJECT_EMPTY_ARRAY : arguments;
    }

    private static CompletableFuture<AsyncResultSetImpl<SqlRow>> executeAsync(@Nullable Transaction transaction, QueryProcessor qryProc, HybridTimestampTracker timestampTracker, String query, CancellationToken token, int pageSize, SqlProperties props, Runnable onComplete, Object ... arguments) {
        try {
            CompletionStage fut = qryProc.queryAsync(props, timestampTracker, (InternalTransaction)transaction, token, query, SecurityContextHolder.getOrThrow(), arguments).thenCompose(cur -> {
                ClientSqlExecuteRequest.doWhenAllCursorsComplete(cur, onComplete);
                return cur.requestNextAsync(pageSize).thenApply(batchRes -> new AsyncResultSetImpl((AsyncSqlCursor<InternalSqlRow>)cur, (AsyncCursor.BatchedResult<InternalSqlRow>)batchRes, pageSize));
            });
            return ((CompletableFuture)fut).exceptionally(th -> {
                onComplete.run();
                Throwable cause = ExceptionUtils.unwrapCause(th);
                throw new CompletionException(SqlExceptionMapperUtil.mapToPublicSqlException(cause));
            });
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(SqlExceptionMapperUtil.mapToPublicSqlException(e));
        }
    }

    private static void doWhenAllCursorsComplete(AsyncSqlCursor<InternalSqlRow> cursor, final Runnable action) {
        final ArrayList dependency = new ArrayList();
        var cursorChainTraverser = new Function<AsyncSqlCursor<?>, CompletableFuture<AsyncSqlCursor<?>>>(){

            @Override
            public CompletableFuture<AsyncSqlCursor<?>> apply(AsyncSqlCursor<?> cursor) {
                dependency.add(cursor.onClose());
                if (cursor.hasNextResult()) {
                    return cursor.nextResult().thenCompose((Function)this);
                }
                return ((CompletableFuture)CompletableFutures.allOf(dependency).thenRun(action)).thenApply(ignored -> cursor);
            }
        };
        cursorChainTraverser.apply(cursor).exceptionally(ex -> {
            action.run();
            return null;
        });
    }
}

