/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.client.handler.requests.sql;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.ignite3.client.handler.ClientResourceRegistry;
import org.apache.ignite3.client.handler.ResponseWriter;
import org.apache.ignite3.client.handler.requests.sql.ClientSqlProperties;
import org.apache.ignite3.client.handler.requests.table.ClientTableCommon;
import org.apache.ignite3.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.hlc.HybridTimestampTracker;
import org.apache.ignite3.internal.sql.api.IgniteSqlImpl;
import org.apache.ignite3.internal.sql.engine.QueryProcessor;
import org.apache.ignite3.internal.tx.InternalTransaction;
import org.apache.ignite3.internal.util.ArrayUtils;
import org.apache.ignite3.lang.CancelHandle;
import org.apache.ignite3.sql.BatchedArguments;
import org.gridgain.internal.license.LicenseFeatureChecker;
import org.gridgain.internal.security.context.SecurityContext;
import org.gridgain.internal.security.context.SecurityContextHolder;

public class ClientSqlExecuteBatchRequest {
    public static CompletableFuture<ResponseWriter> process(Executor operationExecutor, ClientMessageUnpacker in, QueryProcessor sql, ClientResourceRegistry resources, LicenseFeatureChecker licenseFeatureChecker, long requestId, Map<Long, CancelHandle> cancelHandleMap, HybridTimestampTracker tsTracker, String username) {
        SecurityContext context = SecurityContextHolder.getOrThrow();
        CancelHandle cancelHandle = CancelHandle.create();
        cancelHandleMap.put(requestId, cancelHandle);
        CompletableFuture<InternalTransaction> txFut = ClientTableCommon.readTx(in, tsTracker, resources, null, null, null, licenseFeatureChecker, null);
        ClientSqlProperties props = new ClientSqlProperties(in, false);
        String statement = in.unpackString();
        BatchedArguments arguments = ClientSqlExecuteBatchRequest.readArgs(in);
        HybridTimestamp clientTs = HybridTimestamp.nullableHybridTimestamp(in.unpackLong());
        tsTracker.update(clientTs);
        return txFut.thenComposeAsync(tx -> ((CompletableFuture)IgniteSqlImpl.executeBatchCore(sql, tsTracker, tx, cancelHandle.token(), statement, arguments, props.toSqlProps().userName(username), () -> true, () -> {}, cursor -> 0, cursorId -> {}, context).whenComplete((none2, error) -> cancelHandleMap.remove(requestId))).thenApply(affectedRows -> out -> {
            out.packNil();
            out.packBoolean(false);
            out.packBoolean(false);
            out.packBoolean(false);
            out.packLongArray((long[])affectedRows);
        }));
    }

    private static BatchedArguments readArgs(ClientMessageUnpacker in) {
        BatchedArguments arguments = in.unpackBatchedArgumentsFromBinaryTupleArray();
        if (arguments == null) {
            arguments = BatchedArguments.of(ArrayUtils.OBJECT_EMPTY_ARRAY);
        }
        return arguments;
    }
}

