/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.client.handler.requests.compute;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.client.handler.ClientContext;
import org.apache.ignite3.client.handler.NotificationSender;
import org.apache.ignite3.client.handler.ResponseWriter;
import org.apache.ignite3.client.handler.requests.compute.ClientComputeExecuteRequest;
import org.apache.ignite3.client.handler.requests.table.ClientTableCommon;
import org.apache.ignite3.compute.JobExecution;
import org.apache.ignite3.internal.client.proto.ClientComputeJobUnpacker;
import org.apache.ignite3.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite3.internal.client.proto.ProtocolBitmaskFeature;
import org.apache.ignite3.internal.compute.ComputeJobDataHolder;
import org.apache.ignite3.internal.compute.IgniteComputeInternal;
import org.apache.ignite3.internal.compute.events.ComputeEventMetadata;
import org.apache.ignite3.internal.compute.events.ComputeEventMetadataBuilder;
import org.apache.ignite3.internal.network.ClusterService;
import org.apache.ignite3.internal.table.IgniteTablesInternal;
import org.apache.ignite3.internal.table.TableViewInternal;
import org.gridgain.internal.security.context.SecurityContext;
import org.gridgain.internal.security.context.SecurityContextHolder;

public class ClientComputeExecutePartitionedRequest {
    public static CompletableFuture<ResponseWriter> process(ClientMessageUnpacker in, IgniteComputeInternal compute, IgniteTablesInternal tables, ClusterService cluster, NotificationSender notificationSender, ClientContext clientContext) {
        int tableId = in.unpackInt();
        int partitionId = in.unpackInt();
        ClientComputeJobUnpacker.Job job = ClientComputeJobUnpacker.unpackJob(in, clientContext.hasFeature(ProtocolBitmaskFeature.PLATFORM_COMPUTE_JOB));
        UUID taskId = ClientComputeJobUnpacker.unpackTaskId(in, clientContext.hasFeature(ProtocolBitmaskFeature.COMPUTE_TASK_ID));
        SecurityContext securityContext = SecurityContextHolder.getOrThrow();
        return ClientTableCommon.readTableAsync(tableId, tables).thenCompose(table -> {
            ComputeEventMetadataBuilder metadataBuilder = ComputeEventMetadata.builder(ComputeEventMetadata.Type.BROADCAST).eventUser(clientContext.userDetails()).taskId(taskId).tableName(table.name()).clientAddress(clientContext.remoteAddress().toString());
            CompletableFuture<JobExecution<ComputeJobDataHolder>> jobExecutionFut = compute.submitPartitionedInternal((TableViewInternal)table, partitionId, job.deploymentUnits(), job.jobClassName(), job.options(), metadataBuilder, securityContext, job.arg(), null);
            ClientComputeExecuteRequest.sendResultAndState(jobExecutionFut, notificationSender);
            return jobExecutionFut.thenCompose(execution -> execution.idAsync().thenApply(jobId -> out -> {
                out.packInt(table.schemaView().lastKnownSchemaVersion());
                ClientComputeExecuteRequest.packSubmitResult(out, jobId, execution.node());
            }));
        });
    }
}

