/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.structure;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.UpdateContext;
import org.apache.ignite3.internal.catalog.commands.DefaultValue;
import org.apache.ignite3.internal.catalog.commands.DropTableCommand;
import org.apache.ignite3.internal.catalog.commands.DropTableCommandBuilder;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSequenceDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableColumnDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite3.internal.catalog.storage.AlterSequenceEntry;
import org.apache.ignite3.internal.catalog.storage.NewSequenceEntry;
import org.gridgain.internal.snapshots.catalog.CommandState;
import org.gridgain.internal.snapshots.meta.SequenceDescriptorView;
import org.gridgain.internal.snapshots.meta.StructureView;
import org.gridgain.internal.snapshots.structure.Structure;
import org.gridgain.internal.snapshots.structure.StructureHandler;
import org.jetbrains.annotations.Nullable;

public class SequenceStructureHandler
implements StructureHandler {
    @Override
    public Set<Structure> getStructures(Catalog catalog) {
        return catalog.sequences().stream().map(seq -> Structure.toStructure(seq.schemaId(), seq.name(), seq.id(), catalog, seq.tableId())).collect(Collectors.toSet());
    }

    @Override
    @Nullable
    public Structure getStructure(Catalog catalog, CatalogSchemaDescriptor schema, String structureName) {
        CatalogSequenceDescriptor sequence = schema.sequence(structureName);
        return sequence != null ? Structure.toStructure(sequence.schemaId(), sequence.name(), sequence.id(), catalog, sequence.tableId()) : null;
    }

    @Override
    public boolean tryRestoreStructure(UpdateContext updateContext, CommandState commandState, StructureView view, int schemaId, int tableId, AtomicInteger nextGeneratedStructureId) {
        if (!(view instanceof SequenceDescriptorView)) {
            return false;
        }
        Catalog catalog = updateContext.catalog();
        CatalogSequenceDescriptor existingSequence = catalog.sequence(view.schemaName(), view.name());
        CatalogSequenceDescriptor descriptor = SequenceStructureHandler.createSequenceDescriptor((SequenceDescriptorView)view, existingSequence == null ? nextGeneratedStructureId.getAndIncrement() : existingSequence.id(), schemaId, tableId);
        if (existingSequence != null) {
            commandState.applyCommand(new AlterSequenceEntry(descriptor));
            CatalogTableDescriptor sequenceTable = catalog.table(existingSequence.tableId());
            if (sequenceTable != null) {
                commandState.applyCommand(((DropTableCommandBuilder)((DropTableCommandBuilder)((DropTableCommandBuilder)DropTableCommand.builder().schemaName("SYSTEM")).tableName(sequenceTable.name())).validateSystemSchemas(false).ifTableExists(false)).build());
            }
        } else {
            commandState.applyCommand(new NewSequenceEntry(descriptor));
        }
        StructureHandler.renameSystemTable(commandState, view, "SEQ_" + descriptor.id());
        return true;
    }

    @Override
    public boolean tryDropStructure(UpdateContext updateContext, CommandState commandState, StructureView view) {
        return false;
    }

    @Override
    public Set<StructureView> createStructureDescriptors(Catalog catalog, Set<Integer> structureIds) {
        return structureIds.stream().map(catalog::sequence).filter(Objects::nonNull).map(seq -> new SequenceDescriptorView(seq.name(), catalog.schema(seq.schemaId()).name(), seq.increment(), seq.minvalue(), seq.maxvalue(), seq.start(), seq.cachevalue(), catalog.table(seq.tableId()).name())).collect(Collectors.toSet());
    }

    @Override
    public Set<Structure> dependenciesForTables(Catalog catalog, Collection<CatalogTableDescriptor> tables) {
        HashSet<Structure> result = new HashSet<Structure>();
        for (CatalogTableDescriptor table : tables) {
            for (CatalogTableColumnDescriptor column : table.columns()) {
                DefaultValue.FunctionCall functionCall;
                DefaultValue defaultValue = column.defaultValue();
                if (!(defaultValue instanceof DefaultValue.FunctionCall) || !"NEXTVAL".equalsIgnoreCase((functionCall = (DefaultValue.FunctionCall)defaultValue).functionName())) continue;
                List<Object> parameters = functionCall.parameters();
                int sequenceId = (Integer)parameters.get(2);
                CatalogSequenceDescriptor sequence = catalog.sequence(sequenceId);
                result.add(Structure.toStructure(sequence.schemaId(), sequence.name(), sequenceId, catalog, sequence.tableId()));
            }
        }
        return result;
    }

    private static CatalogSequenceDescriptor createSequenceDescriptor(SequenceDescriptorView sequenceView, int id, int schemaId, int tableId) {
        return new CatalogSequenceDescriptor(id, tableId, schemaId, sequenceView.name(), sequenceView.increment(), sequenceView.minvalue(), sequenceView.maxvalue(), sequenceView.start(), sequenceView.cache());
    }
}

