/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.catalog;

import java.util.List;
import java.util.Map;
import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.CatalogCommand;
import org.apache.ignite3.internal.catalog.UpdateContext;
import org.apache.ignite3.internal.catalog.commands.DropTableCommand;
import org.apache.ignite3.internal.catalog.commands.DropTableCommandBuilder;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite3.internal.catalog.storage.UpdateEntry;
import org.gridgain.internal.snapshots.catalog.CommandState;

public class DropExistingTablesCommand
implements CatalogCommand {
    private final Map<String, List<String>> tableNamesBySchema;

    public DropExistingTablesCommand(Map<String, List<String>> tableNamesBySchema) {
        this.tableNamesBySchema = tableNamesBySchema;
    }

    @Override
    public List<UpdateEntry> get(UpdateContext updateContext) {
        Catalog catalog = updateContext.catalog();
        CommandState commandState = new CommandState(catalog);
        for (Map.Entry<String, List<String>> e : this.tableNamesBySchema.entrySet()) {
            String schemaName = e.getKey();
            CatalogSchemaDescriptor schemaDescriptor = catalog.schema(schemaName);
            if (schemaDescriptor == null) continue;
            for (String tableName : e.getValue()) {
                CatalogTableDescriptor tableDescriptor = schemaDescriptor.table(tableName);
                if (tableDescriptor == null || tableDescriptor.cache()) continue;
                CatalogCommand dropTableCommand = ((DropTableCommandBuilder)((DropTableCommandBuilder)DropTableCommand.builder().schemaName(schemaName)).tableName(tableName)).validateSystemSchemas(false).build();
                commandState.applyCommand(dropTableCommand);
            }
        }
        return commandState.updateEntries();
    }
}

