/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.rest.snapshot.exception;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import jakarta.inject.Singleton;
import org.apache.ignite3.internal.rest.api.Problem;
import org.apache.ignite3.internal.rest.constants.HttpCode;
import org.apache.ignite3.internal.rest.problem.HttpProblemResponse;
import org.gridgain.internal.snapshots.SnapshotDecryptionProviderNotFoundException;
import org.gridgain.internal.snapshots.SnapshotEncryptionProviderNotFoundException;
import org.gridgain.internal.snapshots.SnapshotException;
import org.gridgain.internal.snapshots.SnapshotMetaNotFoundException;
import org.gridgain.internal.snapshots.SnapshotNotFoundException;
import org.gridgain.internal.snapshots.SnapshotOperationNotFoundException;
import org.gridgain.internal.snapshots.SnapshotStructuresNotFoundException;
import org.gridgain.internal.snapshots.SnapshotTablesNotFoundException;
import org.gridgain.internal.snapshots.SnapshotUriNotFoundException;

@Singleton
@Requires(classes={SnapshotException.class, ExceptionHandler.class})
public class SnapshotExceptionHandler
implements ExceptionHandler<SnapshotException, HttpResponse<? extends Problem>> {
    public HttpResponse<? extends Problem> handle(HttpRequest request, SnapshotException exception) {
        if (exception instanceof SnapshotNotFoundException || exception instanceof SnapshotMetaNotFoundException || exception instanceof SnapshotOperationNotFoundException || exception instanceof SnapshotTablesNotFoundException || exception instanceof SnapshotStructuresNotFoundException || exception instanceof SnapshotUriNotFoundException || exception instanceof SnapshotEncryptionProviderNotFoundException || exception instanceof SnapshotDecryptionProviderNotFoundException) {
            return HttpProblemResponse.from(Problem.fromHttpCode(HttpCode.NOT_FOUND).detail(exception.getMessage()));
        }
        return HttpProblemResponse.from(Problem.fromHttpCode(HttpCode.BAD_REQUEST).detail(exception.getMessage()));
    }
}

