/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.rbac.roles;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite3.configuration.ConfigurationChangeException;
import org.apache.ignite3.configuration.ConfigurationNodeAlreadyExistException;
import org.apache.ignite3.configuration.NamedListView;
import org.apache.ignite3.internal.util.ExceptionUtils;
import org.gridgain.internal.rbac.configuration.AuthorizationConfiguration;
import org.gridgain.internal.rbac.configuration.PrivilegeNameGenerator;
import org.gridgain.internal.rbac.configuration.RoleConfiguration;
import org.gridgain.internal.rbac.configuration.RoleView;
import org.gridgain.internal.rbac.privileges.Action;
import org.gridgain.internal.rbac.privileges.Privilege;
import org.gridgain.internal.rbac.privileges.Selector;
import org.gridgain.internal.rbac.roles.Role;
import org.gridgain.internal.rbac.roles.RoleStore;
import org.gridgain.internal.rbac.store.LowerCaseString;
import org.gridgain.internal.rbac.store.OperationResult;
import org.jetbrains.annotations.Nullable;

public class ConfigurationRoleStore
implements RoleStore {
    private final AuthorizationConfiguration authorizationConfiguration;

    public ConfigurationRoleStore(AuthorizationConfiguration authorizationConfiguration) {
        this.authorizationConfiguration = authorizationConfiguration;
    }

    @Override
    public CompletableFuture<OperationResult> putIfNotExists(LowerCaseString roleName, Role role) {
        return this.authorizationConfiguration.roles().change(roles -> roles.create(roleName.value(), roleChange -> roleChange.changeDisplayName(role.name()).changePrivileges(privileges -> {
            for (Privilege privilege : role.privileges()) {
                privileges.create(PrivilegeNameGenerator.privilegeName(privilege), privilegeChange -> privilegeChange.changeOn(ConfigurationRoleStore.fromSelector(privilege.selector())));
            }
        }))).handle((unused, throwable) -> {
            if (throwable != null) {
                Throwable unwrap = ExceptionUtils.unwrapCause(throwable);
                if (unwrap instanceof ConfigurationChangeException && unwrap.getCause() instanceof ConfigurationNodeAlreadyExistException) {
                    return OperationResult.ROLE_EXISTS;
                }
                if (unwrap instanceof ConfigurationNodeAlreadyExistException) {
                    return OperationResult.ROLE_EXISTS;
                }
                throw new CompletionException((Throwable)throwable);
            }
            return OperationResult.SUCCESS;
        });
    }

    @Override
    public CompletableFuture<OperationResult> updateIfExists(LowerCaseString roleName, Function<Role, Role> update) {
        RoleConfiguration roleEntry = this.authorizationConfiguration.roles().get(roleName.value());
        if (roleEntry == null) {
            return CompletableFuture.completedFuture(OperationResult.ROLE_NOT_FOUND);
        }
        Role newRole = update.apply(ConfigurationRoleStore.toRole((RoleView)roleEntry.value()));
        return roleEntry.change(role -> role.changePrivileges(rolePrivilegesViews -> {
            ArrayList<String> toRemoveKeys = new ArrayList<String>(rolePrivilegesViews.namedListKeys());
            for (Privilege privilege : newRole.privileges()) {
                toRemoveKeys.remove(PrivilegeNameGenerator.privilegeName(privilege));
                rolePrivilegesViews.createOrUpdate(PrivilegeNameGenerator.privilegeName(privilege), rolePrivilegesChange -> rolePrivilegesChange.changeAction(privilege.action().name()).changeOn(ConfigurationRoleStore.fromSelector(privilege.selector())));
            }
            for (String toRemoveKey : toRemoveKeys) {
                rolePrivilegesViews.delete(toRemoveKey);
            }
        })).thenApply(unused -> OperationResult.SUCCESS);
    }

    private static String fromSelector(Selector selector) {
        String rawString = selector.toRawString();
        return rawString == null ? "" : rawString;
    }

    @Override
    public CompletableFuture<OperationResult> removeIfExists(LowerCaseString roleName) {
        String roleNameKey = roleName.value();
        RoleConfiguration role = this.authorizationConfiguration.roles().get(roleNameKey);
        if (role == null) {
            return CompletableFuture.completedFuture(OperationResult.ROLE_NOT_FOUND);
        }
        return this.authorizationConfiguration.roles().change(roles -> roles.delete(roleNameKey)).thenApply(unused -> OperationResult.SUCCESS);
    }

    @Override
    public Collection<Role> getAll() {
        return this.roleStream().collect(Collectors.toSet());
    }

    @Override
    public Map<LowerCaseString, Role> getAllWithKeys() {
        return this.roleStream().collect(Collectors.toMap(role -> LowerCaseString.from(role.name()), Function.identity()));
    }

    private Stream<Role> roleStream() {
        return ((NamedListView)this.authorizationConfiguration.roles().value()).stream().map(ConfigurationRoleStore::toRole);
    }

    @Override
    @Nullable
    public Role get(LowerCaseString roleName) {
        return this.doGet(roleName);
    }

    @Override
    public List<Role> get(LowerCaseString ... keys) {
        return Arrays.stream(keys).map(this::doGet).collect(Collectors.toList());
    }

    @Nullable
    private Role doGet(LowerCaseString roleName) {
        RoleConfiguration roleEntry = this.authorizationConfiguration.roles().get(roleName.value());
        if (roleEntry == null) {
            return null;
        }
        return ConfigurationRoleStore.toRole((RoleView)roleEntry.value());
    }

    private static Role toRole(RoleView view) {
        Set<Privilege> privileges = view.privileges().stream().map(privilegeView -> {
            Privilege.Builder builder = Privilege.builder().action(Action.valueOf(privilegeView.action()));
            if (!privilegeView.on().isBlank()) {
                builder.selector(privilegeView.on());
            }
            return builder.build();
        }).collect(Collectors.toSet());
        return Role.builder().name(view.displayName()).addPrivileges(privileges).build();
    }
}

