/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.lock;

import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.lang.ByteArray;
import org.apache.ignite3.internal.metastorage.MetaStorageManager;
import org.apache.ignite3.internal.metastorage.dsl.Condition;
import org.apache.ignite3.internal.metastorage.dsl.Conditions;
import org.apache.ignite3.internal.metastorage.dsl.Operations;
import org.apache.ignite3.internal.util.ByteUtils;
import org.apache.ignite3.internal.util.CompletableFutures;

public enum OperationLock {
    PITR,
    ROLLING_UPGRADE;

    private static final ByteArray ONGOING_LOCK_KEY;
    private final byte[] valueBytes = ByteUtils.stringToBytes(this.name());

    public CompletableFuture<Void> start(MetaStorageManager mgr) {
        return mgr.invoke(Conditions.notExists(ONGOING_LOCK_KEY).or(Conditions.value(ONGOING_LOCK_KEY).eq(this.valueBytes)), Operations.put(ONGOING_LOCK_KEY, this.valueBytes), Operations.noop()).thenCompose(success -> {
            if (success.booleanValue()) {
                return CompletableFutures.nullCompletedFuture();
            }
            String msgPrefix = "Can not start " + this.name() + " while already in progress: ";
            return OperationLock.failWithActual(mgr, msgPrefix);
        });
    }

    public CompletableFuture<Void> stop(MetaStorageManager mgr) {
        return mgr.invoke((Condition)Conditions.value(ONGOING_LOCK_KEY).eq(this.valueBytes), Operations.remove(ONGOING_LOCK_KEY), Operations.noop()).thenCompose(success -> {
            if (success.booleanValue()) {
                return CompletableFutures.nullCompletedFuture();
            }
            String msgPrefix = "[possible lifecycle issue] Trying to stop " + this.name() + " but already started: ";
            return OperationLock.failWithActual(mgr, msgPrefix);
        });
    }

    public static CompletableFuture<OperationLock> actual(MetaStorageManager mgr) {
        return mgr.get(ONGOING_LOCK_KEY).thenApply(entry -> {
            if (entry.value() == null) {
                return null;
            }
            for (OperationLock lock : OperationLock.values()) {
                if (!Arrays.equals(entry.value(), lock.valueBytes)) continue;
                return lock;
            }
            throw new IllegalArgumentException("Unexpected value " + ByteUtils.stringFromBytes(entry.value()));
        });
    }

    private static CompletableFuture<Void> failWithActual(MetaStorageManager mgr, String msgPrefix) {
        return OperationLock.actual(mgr).thenApply(actual -> {
            throw new IllegalStateException(msgPrefix + actual);
        });
    }

    static {
        ONGOING_LOCK_KEY = new ByteArray("gridgain.operation.lock");
    }
}

