/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.dcr.metastorage;

import java.util.Objects;
import java.util.UUID;
import org.apache.ignite3.internal.util.ExceptionUtils;
import org.apache.ignite3.lang.TraceableException;
import org.gridgain.internal.dcr.exception.ReplicationException;
import org.gridgain.internal.dcr.metastorage.MetaStoreByteArrayBuilder;
import org.gridgain.internal.dcr.metastorage.MetaStoreByteArrayReader;
import org.gridgain.lang.GridgainErrorGroups;

public class ExceptionEntry {
    private final UUID traceId;
    private final int exceptionCode;
    private final String message;
    private final String workerNode;
    private final String failedEntry;

    public ExceptionEntry(UUID traceId, int exceptionCode, String message, String workerNode, String failedEntry) {
        this.traceId = traceId;
        this.exceptionCode = exceptionCode;
        this.message = message;
        this.workerNode = workerNode;
        this.failedEntry = failedEntry;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExceptionEntry that = (ExceptionEntry)o;
        if (this.exceptionCode != that.exceptionCode) {
            return false;
        }
        if (!Objects.equals(this.message, that.message)) {
            return false;
        }
        if (!Objects.equals(this.workerNode, that.workerNode)) {
            return false;
        }
        if (!Objects.equals(this.traceId, that.traceId)) {
            return false;
        }
        return Objects.equals(this.failedEntry, that.failedEntry);
    }

    public int hashCode() {
        return Objects.hash(this.traceId, this.exceptionCode, this.message, this.workerNode, this.failedEntry);
    }

    public byte[] toByteArray() {
        return new MetaStoreByteArrayBuilder().appendInt(this.exceptionCode).appendString(this.message).appendString(this.workerNode).appendString(this.failedEntry).appendString(this.traceId.toString()).build();
    }

    public static ExceptionEntry fromByteArray(byte[] arr) {
        MetaStoreByteArrayReader reader = new MetaStoreByteArrayReader(arr);
        int exceptionCode = reader.readInt();
        String message = reader.readString();
        String workerNode = reader.readString();
        String failedEntry = reader.readString();
        UUID traceId = UUID.fromString(reader.readString());
        return new ExceptionEntry(traceId, exceptionCode, message, workerNode, failedEntry);
    }

    public ReplicationException buildException() {
        return new ReplicationException(this.traceId, this.exceptionCode, this.message, this.workerNode, this.failedEntry, null);
    }

    public static ExceptionEntry fromException(String nodeName, Throwable t) {
        Throwable e = ExceptionUtils.unwrapCause(t);
        if (e instanceof ReplicationException) {
            ReplicationException replicationException = (ReplicationException)e;
            return new ExceptionEntry(replicationException.traceId(), replicationException.code(), replicationException.getMessage(), replicationException.workerNode(), replicationException.failedEntry());
        }
        return new ExceptionEntry(e instanceof TraceableException ? ((TraceableException)((Object)e)).traceId() : UUID.randomUUID(), GridgainErrorGroups.DataCenterReplication.DCR_ERR, "Internal replication error: " + t.getMessage(), nodeName, "N/A");
    }
}

