/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.decorators;

import java.util.List;
import org.apache.ignite3.internal.cli.core.decorator.Decorator;
import org.apache.ignite3.internal.cli.core.decorator.TerminalOutput;
import org.gridgain.internal.cli.call.rbac.privilege.Privilege;
import org.gridgain.internal.cli.call.rbac.role.Role;

public class RoleDecorator
implements Decorator<Role, TerminalOutput> {
    @Override
    public TerminalOutput decorate(Role data) {
        return () -> '[' + "role: " + data.roleName() + RoleDecorator.formatUsers(data.assignedUsers()) + RoleDecorator.formatPrivileges(data.privileges()) + ']';
    }

    private static StringBuilder formatUsers(List<String> users) {
        if (users.isEmpty()) {
            return new StringBuilder();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(", users: ").append('[');
        for (String user : users) {
            sb.append(user).append(", ");
        }
        sb.delete(sb.length() - 2, sb.length());
        sb.append(']');
        return sb;
    }

    private static StringBuilder formatPrivileges(List<Privilege> privileges) {
        if (privileges.isEmpty()) {
            return new StringBuilder();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(", privileges: ").append('[');
        for (Privilege privilege : privileges) {
            sb.append(privilege.action());
            if (privilege.selector() != null) {
                sb.append(' ').append(privilege.selector());
            }
            sb.append(", ");
        }
        sb.delete(sb.length() - 2, sb.length());
        sb.append(']');
        return sb;
    }
}

