/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.commands.user.role.repl;

import jakarta.inject.Inject;
import java.util.List;
import org.apache.ignite3.internal.cli.commands.BaseCommand;
import org.apache.ignite3.internal.cli.commands.cluster.ClusterUrlMixin;
import org.apache.ignite3.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite3.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.apache.ignite3.internal.cli.core.flow.builder.Flows;
import org.gridgain.internal.cli.call.rbac.assignments.AssignRevokeCallInput;
import org.gridgain.internal.cli.call.rbac.assignments.RevokeRoleCall;
import picocli.CommandLine;

@CommandLine.Command(name="revoke", description={"Revoke role from user"})
public class UserRoleRevokeReplCommand
extends BaseCommand
implements Runnable {
    @CommandLine.Mixin
    private ClusterUrlMixin clusterUrl;
    @CommandLine.Option(names={"--from"}, description={"From username"}, required=true, split=",")
    private List<String> username;
    @CommandLine.Option(names={"--role", "-r"}, description={"Role name"}, required=true, split=",")
    private List<String> roleName;
    @Inject
    private RevokeRoleCall revokeRoleCall;
    @Inject
    private ConnectToClusterQuestion question;

    @Override
    public void run() {
        this.runFlow(this.question.askQuestionIfNotConnected(this.clusterUrl.getClusterUrl()).map(this::input).then(Flows.fromCall(this.revokeRoleCall)).exceptionHandler(ClusterNotInitializedExceptionHandler.createReplHandler("Cannot revoke role")).print());
    }

    private AssignRevokeCallInput input(String clusterUrl) {
        return AssignRevokeCallInput.builder().clusterUrl(clusterUrl).roleNames(this.roleName).usernames(this.username).build();
    }
}

