/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.call.snapshot;

import io.micronaut.core.annotation.Nullable;
import jakarta.inject.Singleton;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite3.internal.cli.core.call.Call;
import org.apache.ignite3.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite3.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite3.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite3.internal.cli.table.Table;
import org.apache.ignite3.rest.client.api.SnapshotManagementApi;
import org.apache.ignite3.rest.client.invoker.ApiException;
import org.apache.ignite3.rest.client.model.SnapshotOperation;
import org.gridgain.internal.cli.call.snapshot.SnapshotStatusCallInput;

@Singleton
public class SnapshotStatusCall
implements Call<SnapshotStatusCallInput, Table> {
    private static final List<String> HEADERS = List.of("Operation ID", "Start time", "Timestamp", "Operation", "Status", "Target Snapshot ID", "Parent Snapshot ID", "Description", "URI", "Path type", "Force");
    private static final List<String> ALL_NODES_HEADERS = Stream.concat(HEADERS.stream(), Stream.of("Node name", "Rows count")).collect(Collectors.toList());
    private static final String TABLE_NAMES_HEADER = "Tables";
    private static final String STRUCTURE_NAMES_HEADER = "Structures";
    private final ApiClientFactory clientFactory;

    public SnapshotStatusCall(ApiClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    @Override
    public DefaultCallOutput<Table> execute(SnapshotStatusCallInput input) {
        SnapshotManagementApi client = new SnapshotManagementApi(this.clientFactory.getClient(input.clusterUrl()));
        try {
            List<String> headers;
            List<SnapshotOperation> operations = input.operationId() == null ? client.getOperations() : client.getOperationById(input.operationId(), input.allNodesOption());
            List<String> list = headers = input.allNodesOption() ? ALL_NODES_HEADERS : HEADERS;
            if (input.showTables()) {
                headers = Stream.concat(headers.stream(), Stream.of(TABLE_NAMES_HEADER, STRUCTURE_NAMES_HEADER)).collect(Collectors.toList());
            }
            List content = operations.stream().flatMap(it -> Stream.of(it.getOperationId().toString(), SnapshotStatusCall.epochMilliToInstantString(it.getStartTimeEpochMilli()), it.getTimestampEpochMilli() == null ? "" : SnapshotStatusCall.epochMilliToInstantString(it.getTimestampEpochMilli()), it.getOperation().toString(), it.getStatus().toString(), SnapshotStatusCall.emptyIfNull(it.getTargetSnapshotId()), SnapshotStatusCall.emptyIfNull(it.getParentSnapshotId()), SnapshotStatusCall.emptyIfNull(it.getDescription()), it.getUri().toString(), it.getPathType().name(), String.valueOf(it.getForce()), SnapshotStatusCall.toStringOrNotApplicable(input.allNodesOption(), it.getNodeName()), SnapshotStatusCall.toStringOrNotApplicable(input.allNodesOption(), it.getRowsSaved()), SnapshotStatusCall.toStringOrNotApplicable(input.showTables(), it.getTableNames()), SnapshotStatusCall.toStringOrNotApplicable(input.showTables(), it.getStructureNames()))).filter(Objects::nonNull).collect(Collectors.toList());
            Table resultTable = new Table(headers, content);
            return DefaultCallOutput.success(resultTable);
        }
        catch (ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, input.clusterUrl()));
        }
    }

    private static String epochMilliToInstantString(long epochMilli) {
        return Instant.ofEpochMilli(epochMilli).toString();
    }

    private static <T> String emptyIfNull(@Nullable T content) {
        return content == null ? "" : content.toString();
    }

    @Nullable
    private static <T> String toStringOrNotApplicable(boolean includeColumn, @Nullable T content) {
        if (includeColumn) {
            return content == null ? "N/A" : content.toString();
        }
        return null;
    }
}

