/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.call.snapshot;

import jakarta.inject.Singleton;
import java.util.UUID;
import org.apache.ignite3.internal.cli.core.call.Call;
import org.apache.ignite3.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite3.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite3.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite3.rest.client.api.SnapshotManagementApi;
import org.apache.ignite3.rest.client.invoker.ApiException;
import org.apache.ignite3.rest.client.model.CreateCommand;
import org.apache.ignite3.rest.client.model.SnapshotType;
import org.gridgain.internal.cli.call.snapshot.SnapshotCreateCallInput;

@Singleton
public class SnapshotCreateCall
implements Call<SnapshotCreateCallInput, String> {
    private final ApiClientFactory clientFactory;

    public SnapshotCreateCall(ApiClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    @Override
    public DefaultCallOutput<String> execute(SnapshotCreateCallInput input) {
        SnapshotManagementApi client = new SnapshotManagementApi(this.clientFactory.getClient(input.clusterUrl()).setReadTimeout(15000));
        Long epochMilli = input.timestamp() == null ? null : Long.valueOf(input.timestamp().toEpochMilli());
        try {
            UUID snapshotId = client.create(new CreateCommand().snapshotType(SnapshotType.fromValue(input.snapshotType().name())).tableNames(input.tableNames()).structureNames(input.structureNames()).timestampEpochMilli(epochMilli).destination(input.destination()).encryptionProvider(input.encryptionProvider()));
            return DefaultCallOutput.success("Snapshot has been started with ID " + snapshotId);
        }
        catch (ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, input.clusterUrl()));
        }
    }
}

