/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.call.cdc.source;

import jakarta.inject.Singleton;
import org.apache.ignite3.internal.cli.core.call.Call;
import org.apache.ignite3.internal.cli.core.call.CallOutput;
import org.apache.ignite3.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite3.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite3.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite3.rest.client.api.CdcManagementApi;
import org.apache.ignite3.rest.client.invoker.ApiException;
import org.apache.ignite3.rest.client.model.SourceStatus;
import org.gridgain.internal.cli.call.cdc.source.SourceNameCallInput;

@Singleton
public class StatusSourceCall
implements Call<SourceNameCallInput, SourceStatus> {
    private final ApiClientFactory apiClientFactory;

    public StatusSourceCall(ApiClientFactory apiClientFactory) {
        this.apiClientFactory = apiClientFactory;
    }

    @Override
    public CallOutput<SourceStatus> execute(SourceNameCallInput input) {
        String clusterUrl = input.clusterUrl();
        try {
            return DefaultCallOutput.success(new CdcManagementApi(this.apiClientFactory.getClient(clusterUrl)).getSourceStatus(input.name()));
        }
        catch (IllegalArgumentException | ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, clusterUrl));
        }
    }
}

