/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cdc.gg8.sink;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Map;
import org.apache.ignite3.internal.schema.Column;
import org.apache.ignite3.table.QualifiedName;
import org.apache.ignite3.table.Tuple;
import org.gridgain.internal.cdc.api.exception.sink.CdcSinkFlushInternalException;
import org.gridgain.internal.cdc.api.exception.sink.CdcSinkInitException;
import org.gridgain.internal.cdc.api.exception.sink.CdcSinkWriteBatchInternalException;
import org.gridgain.internal.cdc.api.sink.SinkDefinition;
import org.gridgain.internal.cdc.api.sink.TableSink;
import org.gridgain.internal.cdc.gg8.sink.CdcUrlClassloader;

public class GridGain8SinkAdapter
implements TableSink {
    private URLClassLoader classLoader;
    private TableSink sink;

    @Override
    public void init(QualifiedName tableName, List<Column> columns, SinkDefinition sinkDef) {
        try {
            Map<String, String> params = sinkDef.parameters().parameters();
            Config config = ConfigFactory.parseString((String)params.get("options"));
            String classpath = config.getString("options.classpath");
            this.initClassloader(classpath);
            String sinkClassname = config.getString("options.sinkClassname");
            this.loadTableSink(sinkClassname);
            this.sink.init(tableName, columns, sinkDef);
        }
        catch (Throwable e) {
            throw new CdcSinkInitException(e);
        }
    }

    @Override
    public void writeBatch(List<Tuple> batch) {
        try {
            this.sink.writeBatch(batch);
        }
        catch (Throwable e) {
            throw new CdcSinkWriteBatchInternalException(e);
        }
    }

    @Override
    public void writeKvBatch(List<Map.Entry<Tuple, Tuple>> kvBatch) {
        try {
            this.sink.writeKvBatch(kvBatch);
        }
        catch (Throwable e) {
            throw new CdcSinkWriteBatchInternalException(e);
        }
    }

    @Override
    public void updateKvBatch(List<Map.Entry<Tuple, Tuple>> kvBatch) {
    }

    @Override
    public void removeBatch(List<Tuple> entriesToDelete) {
    }

    @Override
    public void flush() {
        try {
            this.sink.flush();
        }
        catch (Throwable e) {
            throw new CdcSinkFlushInternalException(e);
        }
    }

    @Override
    public void close() {
        Throwable sinkCloseErr = null;
        try {
            this.sink.close();
        }
        catch (Throwable e) {
            sinkCloseErr = e;
        }
        IOException classLoaderCloseErr = null;
        try {
            this.classLoader.close();
        }
        catch (IOException e) {
            if (sinkCloseErr == null) {
                throw new CdcSinkFlushInternalException(e);
            }
            classLoaderCloseErr = e;
        }
        if (sinkCloseErr != null) {
            CdcSinkFlushInternalException exc = new CdcSinkFlushInternalException(sinkCloseErr);
            if (classLoaderCloseErr != null) {
                exc.addSuppressed(classLoaderCloseErr);
            }
            throw exc;
        }
    }

    private void initClassloader(String classpath) throws MalformedURLException {
        String[] cp = classpath.split(";");
        URL[] urls = new URL[cp.length];
        for (int i = 0; i < cp.length; ++i) {
            urls[i] = new File(cp[i]).toURI().toURL();
        }
        this.classLoader = new CdcUrlClassloader(urls);
    }

    private void loadTableSink(String sinkClassName) throws Exception {
        Class<?> sinkClass = this.classLoader.loadClass(sinkClassName);
        Constructor<?> ctor = sinkClass.getDeclaredConstructor(new Class[0]);
        this.sink = (TableSink)ctor.newInstance(new Object[0]);
    }
}

